/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.FileController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.odb.Editor;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.Collections;

public class CreateFileController
extends FileController {
    public CreateFileController(WindowController parent) {
        super(parent, NSAlert.alert(Locale.localizedString((String)"Create new file", (String)"File"), Locale.localizedString((String)"Enter the name for the new file:", (String)"File"), Locale.localizedString((String)"Create", (String)"File"), EditorFactory.defaultEditor() != null ? Locale.localizedString((String)"Edit", (String)"File") : null, Locale.localizedString((String)"Cancel", (String)"File")));
        this.alert.setIcon(IconCache.documentIcon(null, 64));
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.createFile(this.getWorkdir(), this.filenameField.stringValue(), false);
        } else if (returncode == 0) {
            this.createFile(this.getWorkdir(), this.filenameField.stringValue(), true);
        }
    }

    protected void createFile(final Path workdir, final String filename, final boolean edit) {
        final BrowserController c = (BrowserController)this.parent;
        c.background((BackgroundAction)new BrowserBackgroundAction(c){
            final Path file;
            {
                super(x0);
                this.file = PathFactory.createPath((Session)this.getSession(), (String)workdir.getAbsolute(), (String)filename, (int)1);
            }

            public void run() {
                this.file.touch();
                if (this.file.exists() && edit) {
                    Editor editor = EditorFactory.createEditor(c, this.file);
                    editor.open();
                }
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Uploading {0}", (String)"Status"), this.file.getName());
            }

            public void cleanup() {
                if (filename.charAt(0) == '.') {
                    c.setShowHiddenFiles(true);
                }
                c.reloadData(Collections.singletonList(this.file));
            }
        });
    }
}

