/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSRect;

public class DownloadController
extends AlertController {
    private static Logger log = Logger.getLogger(DownloadController.class);
    protected NSTextField urlField = NSTextField.textfieldWithFrame(new NSRect(0.0, 22.0));
    private String url;

    public void beginSheet() {
        this.setAccessoryView(this.urlField);
        this.updateField(this.urlField, this.url);
        this.alert.setShowsHelp(true);
        super.beginSheet();
    }

    public DownloadController(WindowController parent) {
        this(parent, "");
    }

    public DownloadController(WindowController parent, String url) {
        super(parent, NSAlert.alert(Locale.localizedString((String)"New Download", (String)"Download"), Locale.localizedString((String)"URL", (String)"Download"), Locale.localizedString((String)"Download", (String)"Download"), null, Locale.localizedString((String)"Cancel", (String)"Download")), 1);
        this.url = url;
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            Host host = Host.parse((String)this.urlField.stringValue());
            DownloadTransfer transfer = new DownloadTransfer(PathFactory.createPath((Session)SessionFactory.createSession((Host)host), (String)host.getDefaultPath(), (int)1));
            TransferController.instance().startTransfer((Transfer)transfer);
        }
    }

    protected boolean validateInput() {
        Host host = Host.parse((String)this.urlField.stringValue());
        return StringUtils.isNotBlank((String)host.getDefaultPath());
    }

    protected void help() {
        StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
        site.append("/howto/download");
        DownloadController.openUrl(site.toString());
    }
}

