/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.TransferPromptModel;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadPromptModel
extends TransferPromptModel {
    private PathFilter<Path> filter = new TransferPromptModel.PromptFilter(){

        public boolean accept(Path child) {
            TransferPromptModel.log.debug((Object)("accept:" + child));
            if (child.getLocal().exists()) {
                if (child.attributes().isFile() && child.getLocal().attributes().getSize() == 0L) {
                    return false;
                }
                return super.accept(child);
            }
            return false;
        }
    };

    public DownloadPromptModel(TransferPromptController c, Transfer transfer) {
        super(c, transfer);
    }

    @Override
    protected PathFilter<Path> filter() {
        return this.filter;
    }

    @Override
    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.tableViewCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals("SIZE")) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)item.getLocal().attributes().getSize()), TableCellAttributes.browserFontRightAlignment()));
            }
            if (identifier.equals("WARNING")) {
                if (item.attributes().isFile()) {
                    if (item.attributes().getSize() == 0L) {
                        return this.tableViewCache.put(item, identifier, IconCache.iconNamed("alert.tiff"));
                    }
                    if (item.getLocal().attributes().getSize() > item.attributes().getSize()) {
                        return this.tableViewCache.put(item, identifier, IconCache.iconNamed("alert.tiff"));
                    }
                }
                return null;
            }
            return super.objectValueForItem(item, identifier);
        }
        return cached;
    }
}

