/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class FileController
extends AlertController {
    protected static Logger log = Logger.getLogger(FileController.class);
    protected NSTextField filenameField = NSTextField.textfieldWithFrame(new NSRect(0.0, 22.0));

    public FileController(WindowController parent, NSAlert alert) {
        super(parent, alert);
    }

    public void beginSheet() {
        this.setAccessoryView(this.filenameField);
        this.alert.setShowsHelp(true);
        super.beginSheet();
        this.filenameField.selectText(null);
        this.window().fieldEditor_forObject(true, this.filenameField).setSelectedRange(NSRange.NSMakeRange(new NSUInteger(0L), new NSUInteger(FilenameUtils.getBaseName((String)this.filenameField.stringValue()).length())));
    }

    protected Path getWorkdir() {
        Path selected;
        if (((BrowserController)this.parent).getSelectionCount() == 1 && null != (selected = ((BrowserController)this.parent).getSelectedPath())) {
            return selected.getParent();
        }
        return ((BrowserController)this.parent).workdir();
    }

    protected Path getSelected() {
        return ((BrowserController)this.parent).getSelectedPath();
    }

    protected Session getSession() {
        return ((BrowserController)this.parent).getSession();
    }

    protected boolean validateInput() {
        if (StringUtils.contains((String)this.filenameField.stringValue(), (char)'/')) {
            return false;
        }
        if (StringUtils.isNotBlank((String)this.filenameField.stringValue())) {
            Path file = PathFactory.createPath((Session)this.getSession(), (String)this.getWorkdir().getAbsolute(), (String)this.filenameField.stringValue(), (int)1);
            return !file.exists();
        }
        return false;
    }

    protected void help() {
        StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
        site.append("/howto/browser");
        FileController.openUrl(site.toString());
    }
}

