/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.FileController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.log4j.Logger;

public class FolderController
extends FileController {
    private static Logger log = Logger.getLogger(FolderController.class);

    public FolderController(WindowController parent) {
        super(parent, NSAlert.alert(Locale.localizedString((String)"Create new folder", (String)"Folder"), Locale.localizedString((String)"Enter the name for the new folder:", (String)"Folder"), Locale.localizedString((String)"Create", (String)"Folder"), null, Locale.localizedString((String)"Cancel", (String)"Folder")));
        this.alert.setIcon(IconCache.iconNamed("newfolder.tiff", 64));
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.createFolder(this.getWorkdir(), this.filenameField.stringValue());
        }
    }

    protected void createFolder(final Path workdir, final String filename) {
        final BrowserController c = (BrowserController)this.parent;
        c.background((BackgroundAction)new BrowserBackgroundAction(c){
            final Path folder;
            {
                super(x0);
                this.folder = PathFactory.createPath((Session)this.getSession(), (String)workdir.getAbsolute(), (String)filename, (int)2);
            }

            public void run() {
                this.folder.mkdir(false);
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Making directory {0}", (String)"Status"), this.folder.getName());
            }

            public void cleanup() {
                if (filename.charAt(0) == '.') {
                    c.setShowHiddenFiles(true);
                }
                c.reloadData(Collections.singletonList(this.folder));
            }
        });
    }
}

