/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSComboBox;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSRect;

public class GotoController
extends AlertController {
    private static Logger log = Logger.getLogger(GotoController.class);
    private NSComboBox folderCombobox;
    private ProxyController folderComboboxModel = new FolderComboboxModel();

    public GotoController(WindowController parent) {
        super(parent, NSAlert.alert(Locale.localizedString((String)"Go to folder", (String)"Goto"), Locale.localizedString((String)"Enter the pathname to list:", (String)"Goto"), Locale.localizedString((String)"Go", (String)"Goto"), null, Locale.localizedString((String)"Cancel", (String)"Goto")));
        this.alert.setIcon(IconCache.folderIcon(64));
        this.folderCombobox = NSComboBox.textfieldWithFrame(new NSRect(0.0, 26.0));
        this.folderCombobox.setCompletes(true);
        this.folderCombobox.setUsesDataSource(true);
        this.folderCombobox.setDataSource(this.folderComboboxModel.id());
        this.folderCombobox.setStringValue(((BrowserController)this.parent).workdir().getAbsolute());
        this.setAccessoryView(this.folderCombobox);
    }

    protected void invalidate() {
        this.folderCombobox.setDelegate(null);
        this.folderCombobox.setDataSource(null);
        super.invalidate();
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.gotoFolder(((BrowserController)this.parent).workdir(), this.folderCombobox.stringValue());
        }
    }

    protected boolean validateInput() {
        return StringUtils.isNotBlank((String)this.folderCombobox.stringValue());
    }

    protected Session getSession() {
        return ((BrowserController)this.parent).getSession();
    }

    protected void gotoFolder(Path workdir, String filename) {
        BrowserController c = (BrowserController)this.parent;
        Path dir = !filename.startsWith(String.valueOf('/')) ? PathFactory.createPath((Session)this.getSession(), (String)workdir.getAbsolute(), (String)filename, (int)2) : PathFactory.createPath((Session)this.getSession(), (String)filename, (int)2);
        if (workdir.getParent().equals((Object)dir)) {
            c.setWorkdir(dir, workdir);
        } else {
            c.setWorkdir(dir);
        }
    }

    private class FolderComboboxModel
    extends ProxyController
    implements NSComboBox.DataSource {
        private final Comparator<Path> comparator = new NullComparator();
        private final PathFilter<Path> filter = new PathFilter<Path>(){

            public boolean accept(Path p) {
                return p.attributes().isDirectory();
            }
        };

        private FolderComboboxModel() {
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox combo) {
            if (!((BrowserController)GotoController.this.parent).isMounted()) {
                return new NSInteger(0L);
            }
            return new NSInteger(((BrowserController)GotoController.this.parent).workdir().children(this.comparator, this.filter).size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return (NSObject)((Path)((BrowserController)GotoController.this.parent).workdir().children(this.comparator, this.filter).get(row.intValue())).getReference().unique();
        }
    }
}

