/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Keychain;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.RendezvousResponder;
import ch.cyberduck.core.SystemConfigurationProxy;
import ch.cyberduck.core.SystemConfigurationReachability;
import ch.cyberduck.core.aquaticprime.Donation;
import ch.cyberduck.core.aquaticprime.Receipt;
import ch.cyberduck.core.sparkle.Updater;
import ch.cyberduck.ui.cocoa.AlertHostKeyController;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.PromptLoginController;
import ch.cyberduck.ui.cocoa.UserDefaultsDateFormatter;
import ch.cyberduck.ui.cocoa.UserDefaultsPreferences;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.cyberduck.ui.cocoa.foundation.NSGarbageCollector;
import ch.cyberduck.ui.cocoa.i18n.BundleLocale;
import ch.cyberduck.ui.cocoa.model.FinderLocal;
import ch.cyberduck.ui.cocoa.model.OutlinePathReference;
import ch.cyberduck.ui.cocoa.quicklook.DeprecatedQuickLook;
import ch.cyberduck.ui.cocoa.quicklook.QuartzQuickLook;
import ch.cyberduck.ui.cocoa.serializer.HostPlistReader;
import ch.cyberduck.ui.cocoa.serializer.PlistDeserializer;
import ch.cyberduck.ui.cocoa.serializer.PlistSerializer;
import ch.cyberduck.ui.cocoa.serializer.PlistWriter;
import ch.cyberduck.ui.cocoa.serializer.ProtocolPlistReader;
import ch.cyberduck.ui.cocoa.serializer.TransferPlistReader;
import ch.cyberduck.ui.growl.GrowlNative;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MainApplication {
    private static Logger log = Logger.getLogger(MainApplication.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        NSAutoreleasePool pool = NSAutoreleasePool.push();
        try {
            NSApplication app = NSApplication.sharedApplication();
            FinderLocal.register();
            UserDefaultsPreferences.register();
            BundleLocale.register();
            GrowlNative.registerImpl();
            if (null == Updater.getFeed()) {
                Receipt.register();
            } else {
                Donation.register();
            }
            PlistDeserializer.register();
            PlistSerializer.register();
            HostPlistReader.register();
            TransferPlistReader.register();
            ProtocolPlistReader.register();
            OutlinePathReference.register();
            PlistWriter.register();
            Keychain.register();
            SystemConfigurationProxy.register();
            SystemConfigurationReachability.register();
            UserDefaultsDateFormatter.register();
            DeprecatedQuickLook.register();
            QuartzQuickLook.register();
            PromptLoginController.register();
            AlertHostKeyController.register();
            if (Preferences.instance().getBoolean("rendezvous.enable")) {
                RendezvousResponder.register();
            }
            ProtocolFactory.register();
            Logger root = Logger.getRootLogger();
            root.setLevel(Level.toLevel((String)Preferences.instance().getProperty("logging")));
            if (log.isInfoEnabled()) {
                log.info((Object)("Default garbage collector for the current process:" + NSGarbageCollector.defaultCollector()));
                log.info((Object)("Encoding " + System.getProperty("file.encoding")));
            }
            MainController c = new MainController();
            app.setDelegate(c.id());
            app.run();
        }
        finally {
            pool.drain();
        }
    }
}

