/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.RendezvousFactory;
import ch.cyberduck.core.RendezvousListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.importer.CrossFtpBookmarkCollection;
import ch.cyberduck.core.importer.FetchBookmarkCollection;
import ch.cyberduck.core.importer.FilezillaBookmarkCollection;
import ch.cyberduck.core.importer.FireFtpBookmarkCollection;
import ch.cyberduck.core.importer.FlowBookmarkCollection;
import ch.cyberduck.core.importer.InterarchyBookmarkCollection;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.importer.TransmitBookmarkCollection;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.serializer.ProtocolReaderFactory;
import ch.cyberduck.core.sparkle.Updater;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.ActivityController;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.DownloadController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.PreferencesController;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.WindowListener;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.ArchiveMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.BookmarkMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.CopyURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.EditMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.HistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.OpenURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.RendezvousMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSAppleEventDescriptor;
import ch.cyberduck.ui.cocoa.foundation.NSAppleEventManager;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.urlhandler.URLSchemeHandlerConfiguration;
import ch.cyberduck.ui.growl.Growl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainController
extends BundleController
implements NSApplication.Delegate {
    private static Logger log = Logger.getLogger(MainController.class);
    public static final int kInternetEventClass = 1196773964;
    public static final int kAEGetURL = 1196773964;
    public static final int kAEFetchURL = 1179996748;
    public static final int keyAEResult = 0x2D2D2D2D;
    private Updater updater;
    private NSMenu applicationMenu;
    private NSMenu encodingMenu;
    private NSMenu columnMenu;
    private NSMenu editMenu;
    private EditMenuDelegate editMenuDelegate;
    private NSMenu urlMenu;
    private URLMenuDelegate urlMenuDelegate;
    private NSMenu openUrlMenu;
    private URLMenuDelegate openUrlMenuDelegate;
    private NSMenu archiveMenu;
    private ArchiveMenuDelegate archiveMenuDelegate;
    private NSMenu bookmarkMenu;
    private BookmarkMenuDelegate bookmarkMenuDelegate;
    private NSMenu historyMenu;
    private HistoryMenuDelegate historyMenuDelegate;
    private NSMenu rendezvousMenu;
    private RendezvousMenuDelegate rendezvousMenuDelegate;
    private HistoryCollection sessions = new HistoryCollection(LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"), (String)"Sessions"));
    private boolean donationPrompt = true;
    private WindowController donationController;
    private static List<BrowserController> browsers = new ArrayList<BrowserController>();

    public MainController() {
        this.loadBundle();
    }

    @Override
    public void awakeFromNib() {
        NSAppleEventManager.sharedAppleEventManager().setEventHandler_andSelector_forEventClass_andEventID(this.id(), Foundation.selector("handleGetURLEvent:withReplyEvent:"), 1196773964, 1196773964);
        super.awakeFromNib();
    }

    public void handleGetURLEvent_withReplyEvent(NSAppleEventDescriptor event, NSAppleEventDescriptor reply) {
        log.debug((Object)("Received URL from Apple Event:" + event));
        NSAppleEventDescriptor param = event.paramDescriptorForKeyword(0x2D2D2D2D);
        if (null == param) {
            log.error((Object)"No URL parameter");
            return;
        }
        String url = param.stringValue();
        if (StringUtils.isEmpty((String)url)) {
            log.error((Object)"URL parameter is empty");
            return;
        }
        if ("x-cyberduck-action:update".equals(url)) {
            this.updateMenuClicked(null);
        } else {
            Session s;
            Path p;
            Host h = Host.parse((String)url);
            if (StringUtils.isNotEmpty((String)h.getDefaultPath()) && !h.getDefaultPath().endsWith(String.valueOf('/')) && StringUtils.isNotBlank((String)(p = PathFactory.createPath((Session)(s = SessionFactory.createSession((Host)h)), (String)h.getDefaultPath(), (int)1)).getExtension())) {
                TransferController.instance().startTransfer((Transfer)new DownloadTransfer(p));
                return;
            }
            for (BrowserController controller : MainController.getBrowsers()) {
                if (!controller.isMounted() || !controller.getSession().getHost().toURL().equals(h.toURL())) continue;
                controller.window().makeKeyAndOrderFront(null);
                return;
            }
            BrowserController doc = MainController.newDocument();
            doc.mount(h);
        }
    }

    public void updateMenuClicked(ID sender) {
        if (null == this.updater) {
            this.updater = Updater.create();
        }
        this.updater.checkForUpdates(null);
    }

    public void setApplicationMenu(NSMenu menu) {
        this.applicationMenu = menu;
        this.updateLicenseMenu();
        this.updateUpdateMenu();
    }

    private void updateLicenseMenu() {
        License key = LicenseFactory.find();
        if (key.isReceipt()) {
            this.applicationMenu.removeItemAtIndex(new NSInteger(5L));
            this.applicationMenu.removeItemAtIndex(new NSInteger(4L));
        } else {
            NSDictionary KEY_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.userFontOfSize(NSFont.smallSystemFontSize()), NSColor.darkGrayColor()), NSArray.arrayWithObjects("NSFont", "NSColor"));
            this.applicationMenu.itemAtIndex(new NSInteger(5L)).setAttributedTitle(NSAttributedString.attributedStringWithAttributes(key.toString(), KEY_FONT_ATTRIBUTES));
        }
    }

    private void updateUpdateMenu() {
        if (null == Updater.getFeed()) {
            this.applicationMenu.removeItemAtIndex(new NSInteger(1L));
        }
    }

    public void setEncodingMenu(NSMenu encodingMenu) {
        this.encodingMenu = encodingMenu;
        for (String charset : MainController.availableCharsets()) {
            this.encodingMenu.addItemWithTitle_action_keyEquivalent(charset, Foundation.selector("encodingMenuClicked:"), "");
        }
    }

    public void setColumnMenu(NSMenu columnMenu) {
        this.columnMenu = columnMenu;
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("browser.columnKind", Locale.localizedString((String)"Kind"));
        columns.put("browser.columnExtension", Locale.localizedString((String)"Extension"));
        columns.put("browser.columnSize", Locale.localizedString((String)"Size"));
        columns.put("browser.columnModification", Locale.localizedString((String)"Modified"));
        columns.put("browser.columnOwner", Locale.localizedString((String)"Owner"));
        columns.put("browser.columnGroup", Locale.localizedString((String)"Group"));
        columns.put("browser.columnPermissions", Locale.localizedString((String)"Permissions"));
        Iterator identifiers = columns.keySet().iterator();
        int i = 0;
        Iterator iter = columns.values().iterator();
        while (iter.hasNext()) {
            NSMenuItem item = this.columnMenu.addItemWithTitle_action_keyEquivalent((String)iter.next(), Foundation.selector("columnMenuClicked:"), "");
            String identifier = (String)identifiers.next();
            item.setState(Preferences.instance().getBoolean(identifier) ? 1 : 0);
            item.setRepresentedObject(identifier);
            ++i;
        }
    }

    public void columnMenuClicked(NSMenuItem sender) {
        String identifier = sender.representedObject();
        boolean enabled = !Preferences.instance().getBoolean(identifier);
        sender.setState(enabled ? 1 : 0);
        Preferences.instance().setProperty(identifier, enabled);
        BrowserController.updateBrowserTableColumns();
    }

    public void setEditMenu(NSMenu editMenu) {
        this.editMenu = editMenu;
        this.editMenuDelegate = new EditMenuDelegate(){

            protected Local getSelectedFile() {
                List<BrowserController> browsers = MainController.getBrowsers();
                for (BrowserController controller : browsers) {
                    if (!controller.window().isKeyWindow()) continue;
                    return controller.getSelectedFile();
                }
                return null;
            }

            protected ID getTarget() {
                return MainController.getBrowser().id();
            }
        };
        this.editMenu.setDelegate(this.editMenuDelegate.id());
    }

    public void setUrlMenu(NSMenu urlMenu) {
        this.urlMenu = urlMenu;
        this.urlMenuDelegate = new CopyURLMenuDelegate(){

            @Override
            protected List<Path> getSelected() {
                List<BrowserController> browsers = MainController.getBrowsers();
                for (BrowserController controller : browsers) {
                    if (!controller.window().isKeyWindow()) continue;
                    List<Path> selected = controller.getSelectedPaths();
                    if (selected.isEmpty() && controller.isMounted()) {
                        return Collections.singletonList(controller.workdir());
                    }
                    return selected;
                }
                return Collections.emptyList();
            }
        };
        this.urlMenu.setDelegate(this.urlMenuDelegate.id());
    }

    public void setOpenUrlMenu(NSMenu openUrlMenu) {
        this.openUrlMenu = openUrlMenu;
        this.openUrlMenuDelegate = new OpenURLMenuDelegate(){

            @Override
            protected List<Path> getSelected() {
                List<BrowserController> browsers = MainController.getBrowsers();
                for (BrowserController controller : browsers) {
                    if (!controller.window().isKeyWindow()) continue;
                    List<Path> selected = controller.getSelectedPaths();
                    if (selected.isEmpty() && controller.isMounted()) {
                        return Collections.singletonList(controller.workdir());
                    }
                    return selected;
                }
                return Collections.emptyList();
            }
        };
        this.openUrlMenu.setDelegate(this.openUrlMenuDelegate.id());
    }

    public void setArchiveMenu(NSMenu archiveMenu) {
        this.archiveMenu = archiveMenu;
        this.archiveMenuDelegate = new ArchiveMenuDelegate(){

            protected ID getTarget() {
                return MainController.getBrowser().id();
            }
        };
        this.archiveMenu.setDelegate(this.archiveMenuDelegate.id());
    }

    public void setBookmarkMenu(NSMenu bookmarkMenu) {
        this.bookmarkMenu = bookmarkMenu;
        this.bookmarkMenuDelegate = new BookmarkMenuDelegate(){

            protected ID getTarget() {
                return MainController.getBrowser().id();
            }
        };
        this.bookmarkMenu.setDelegate(this.bookmarkMenuDelegate.id());
    }

    public void setHistoryMenu(NSMenu historyMenu) {
        this.historyMenu = historyMenu;
        this.historyMenuDelegate = new HistoryMenuDelegate(){

            protected ID getTarget() {
                return MainController.getBrowser().id();
            }
        };
        this.historyMenu.setDelegate(this.historyMenuDelegate.id());
    }

    public void setRendezvousMenu(NSMenu rendezvousMenu) {
        this.rendezvousMenu = rendezvousMenu;
        this.rendezvousMenuDelegate = new RendezvousMenuDelegate(){

            protected ID getTarget() {
                return MainController.getBrowser().id();
            }
        };
        this.rendezvousMenu.setDelegate(this.rendezvousMenuDelegate.id());
    }

    public void historyMenuClicked(NSMenuItem sender) {
        HistoryCollection.defaultCollection().open();
    }

    public void bugreportMenuClicked(ID sender) {
        MainController.openUrl(Preferences.instance().getProperty("website.bug"));
    }

    public void helpMenuClicked(ID sender) {
        MainController.openUrl(Preferences.instance().getProperty("website.help"));
    }

    public void faqMenuClicked(ID sender) {
        LocalFactory.createLocal((String)NSBundle.mainBundle().pathForResource_ofType("Cyberduck FAQ", "rtfd")).open();
    }

    public void licenseMenuClicked(ID sender) {
        LocalFactory.createLocal((String)NSBundle.mainBundle().pathForResource_ofType("License", "txt")).open();
    }

    public void acknowledgmentsMenuClicked(ID sender) {
        LocalFactory.createLocal((String)NSBundle.mainBundle().pathForResource_ofType("Acknowledgments", "rtf")).open();
    }

    public void websiteMenuClicked(ID sender) {
        MainController.openUrl(Preferences.instance().getProperty("website.home"));
    }

    public void forumMenuClicked(ID sender) {
        MainController.openUrl(Preferences.instance().getProperty("website.forum"));
    }

    public void donateMenuClicked(ID sender) {
        MainController.openUrl(Preferences.instance().getProperty("website.donate"));
    }

    public void aboutMenuClicked(ID sender) {
        NSDictionary dict = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleShortVersionString").toString(), NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleVersion").toString()), NSArray.arrayWithObjects("ApplicationVersion", "Version"));
        NSApplication.sharedApplication().orderFrontStandardAboutPanelWithOptions(dict);
    }

    public void feedbackMenuClicked(ID sender) {
        MainController.openUrl(Preferences.instance().getProperty("mail.feedback") + "?subject=" + Preferences.instance().getProperty("application.name") + "-" + Preferences.instance().getProperty("application.version"));
    }

    public void preferencesMenuClicked(ID sender) {
        PreferencesController controller = PreferencesController.instance();
        controller.window().makeKeyAndOrderFront(null);
    }

    public void newDownloadMenuClicked(ID sender) {
        this.showTransferQueueClicked(sender);
        DownloadController c = new DownloadController(TransferController.instance());
        ((SheetController)c).beginSheet();
    }

    public void newBrowserMenuClicked(ID sender) {
        this.openDefaultBookmark(MainController.newDocument(true));
    }

    public void showTransferQueueClicked(ID sender) {
        TransferController c = TransferController.instance();
        c.window().makeKeyAndOrderFront(null);
    }

    public void showActivityWindowClicked(ID sender) {
        ActivityController c = ActivityController.instance();
        if (c.isVisible()) {
            c.window().close();
        } else {
            c.window().orderFront(null);
        }
    }

    @Override
    public boolean application_openFile(NSApplication app, String filename) {
        log.debug((Object)("applicationOpenFile:" + filename));
        Local f = LocalFactory.createLocal((String)filename);
        if (f.exists()) {
            if ("duck".equals(f.getExtension())) {
                Host host = (Host)HostReaderFactory.instance().read(f);
                MainController.newDocument().mount(host);
                return true;
            }
            if ("cyberducklicense".equals(f.getExtension())) {
                License l = LicenseFactory.create((Local)f);
                if (l.verify()) {
                    NSAlert alert = NSAlert.alert(l.toString(), Locale.localizedString((String)"Thanks for your support! Your contribution helps to further advance development to make Cyberduck even better.", (String)"License") + "\n\n" + Locale.localizedString((String)"Your donation key has been copied to the Application Support folder.", (String)"License"), Locale.localizedString((String)"Continue", (String)"License"), null, null);
                    alert.setAlertStyle(1);
                    if (this.alert(alert) == 1) {
                        f.copy((AbstractPath)LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"), (String)f.getName()));
                        for (BrowserController c : MainController.getBrowsers()) {
                            c.removeDonateWindowTitle();
                        }
                        this.updateLicenseMenu();
                    }
                } else {
                    NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Not a valid donation key", (String)"License"), Locale.localizedString((String)"This donation key does not appear to be valid.", (String)"License"), Locale.localizedString((String)"Continue", (String)"License"), null, null);
                    alert.setAlertStyle(0);
                    alert.setShowsHelp(true);
                    alert.setDelegate(new ProxyController(){

                        public boolean alertShowHelp(NSAlert alert) {
                            StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
                            site.append("/").append("faq");
                            BundleController.openUrl(site.toString());
                            return true;
                        }
                    }.id());
                    this.alert(alert);
                }
                return true;
            }
            if ("cyberduckprofile".equals(f.getExtension())) {
                Protocol profile = (Protocol)ProtocolReaderFactory.instance().read(f);
                profile.register();
                Host host = new Host(profile, profile.getDefaultHostname(), profile.getDefaultPort());
                MainController.newDocument().addBookmark(host);
                Local profiles = LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"), (String)"Profiles");
                profiles.mkdir(true);
                f.copy((AbstractPath)LocalFactory.createLocal((Local)profiles, (String)f.getName()));
            } else {
                return this.upload(f);
            }
        }
        return false;
    }

    private boolean upload(Local f) {
        return this.upload(Collections.singletonList(f));
    }

    private boolean upload(final List<Local> files) {
        Host open = null;
        String workdir = String.valueOf('/');
        for (BrowserController controller : MainController.getBrowsers()) {
            if (!controller.isMounted()) continue;
            open = controller.getSession().getHost();
            workdir = controller.workdir().getAbsolute();
            break;
        }
        final NSPopUpButton bookmarksPopup = NSPopUpButton.buttonWithFrame(new NSRect(0.0, 26.0));
        bookmarksPopup.setToolTip(Locale.localizedString((String)"Bookmarks"));
        for (Host b : BookmarkCollection.defaultCollection()) {
            String title = b.getNickname();
            int i = 1;
            while (bookmarksPopup.itemWithTitle(title) != null) {
                title = b.getNickname() + "-" + i;
                ++i;
            }
            bookmarksPopup.addItemWithTitle(title);
            bookmarksPopup.lastItem().setImage(IconCache.iconNamed(b.getProtocol().icon(), 16));
            bookmarksPopup.lastItem().setRepresentedObject(b.getUuid());
            if (!b.equals((Object)open)) continue;
            bookmarksPopup.selectItemAtIndex(bookmarksPopup.indexOfItem(bookmarksPopup.lastItem()));
        }
        if (null == open) {
            int i = 0;
            for (Host bookmark : BookmarkCollection.defaultCollection()) {
                boolean found = false;
                for (Local file : files) {
                    if (!file.isChild((AbstractPath)bookmark.getDownloadFolder())) continue;
                    bookmarksPopup.selectItemAtIndex(new NSInteger(i));
                    found = true;
                    break;
                }
                if (found) break;
                ++i;
            }
        }
        if (-1 == bookmarksPopup.indexOfSelectedItem().intValue()) {
            bookmarksPopup.selectItemAtIndex(new NSInteger(0L));
        }
        final TransferController t = TransferController.instance();
        final Host mount = open;
        final String destination = workdir;
        AlertController alert = new AlertController(t, NSAlert.alert("Select Bookmark", MessageFormat.format("Upload {0} to the selected bookmark.", files.size() == 1 ? files.iterator().next().getName() : MessageFormat.format(Locale.localizedString((String)"{0} Files"), String.valueOf(files.size()))), Locale.localizedString((String)"Upload"), Locale.localizedString((String)"Cancel"), null)){

            public void callback(int returncode) {
                if (1 == returncode) {
                    String selected = bookmarksPopup.selectedItem().representedObject();
                    for (Host bookmark : BookmarkCollection.defaultCollection()) {
                        if (!bookmark.getUuid().equals(selected)) continue;
                        String parent = destination;
                        if (!bookmark.equals((Object)mount) && StringUtils.isNotBlank((String)bookmark.getDefaultPath())) {
                            parent = bookmark.getDefaultPath();
                        }
                        Session session = SessionFactory.createSession((Host)bookmark);
                        ArrayList<Path> roots = new ArrayList<Path>();
                        for (Local file : files) {
                            roots.add(PathFactory.createPath((Session)session, (String)parent, (Local)file));
                        }
                        t.startTransfer((Transfer)new UploadTransfer(roots));
                        break;
                    }
                }
            }

            protected boolean validateInput() {
                return StringUtils.isNotEmpty((String)bookmarksPopup.selectedItem().representedObject());
            }
        };
        alert.setAccessoryView(bookmarksPopup);
        alert.beginSheet();
        return true;
    }

    @Override
    public boolean application_openTempFile(NSApplication app, String filename) {
        log.debug((Object)("applicationOpenTempFile:" + filename));
        return this.application_openFile(app, filename);
    }

    @Override
    public boolean applicationShouldOpenUntitledFile(NSApplication sender) {
        log.debug((Object)"applicationShouldOpenUntitledFile");
        return Preferences.instance().getBoolean("browser.openUntitled");
    }

    @Override
    public boolean applicationOpenUntitledFile(NSApplication app) {
        log.debug((Object)"applicationOpenUntitledFile");
        return false;
    }

    private void openDefaultBookmark(BrowserController controller) {
        String defaultBookmark = Preferences.instance().getProperty("browser.defaultBookmark");
        if (null == defaultBookmark) {
            log.info((Object)"No default bookmark configured");
            return;
        }
        Host bookmark = BookmarkCollection.defaultCollection().lookup(defaultBookmark);
        if (null == bookmark) {
            log.info((Object)"Default bookmark no more available");
            return;
        }
        for (BrowserController browser : MainController.getBrowsers()) {
            if (!browser.hasSession() || !browser.getSession().getHost().equals((Object)bookmark)) continue;
            log.debug((Object)"Default bookmark already mounted");
            return;
        }
        log.debug((Object)("Mounting default bookmark " + bookmark));
        controller.mount(bookmark);
    }

    @Override
    public boolean applicationShouldHandleReopen_hasVisibleWindows(NSApplication app, boolean visibleWindowsFound) {
        log.debug((Object)"applicationShouldHandleReopen");
        if (MainController.getBrowsers().isEmpty() && !TransferController.instance().isVisible()) {
            this.openDefaultBookmark(MainController.newDocument());
        }
        NSWindow miniaturized = null;
        for (BrowserController controller : MainController.getBrowsers()) {
            if (!controller.window().isMiniaturized()) {
                return false;
            }
            if (null != miniaturized) continue;
            miniaturized = controller.window();
        }
        if (null == miniaturized) {
            return false;
        }
        miniaturized.deminiaturize(null);
        return false;
    }

    @Override
    public void applicationDidFinishLaunching(NSNotification notification) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Running Java " + System.getProperty("java.version") + " on " + System.getProperty("os.arch")));
            log.info((Object)("Available localizations:" + NSBundle.mainBundle().localizations()));
            log.info((Object)("Current locale:" + java.util.Locale.getDefault()));
        }
        if (Preferences.instance().getBoolean("browser.openUntitled")) {
            MainController.newDocument();
        }
        if (Preferences.instance().getBoolean("queue.openByDefault")) {
            this.showTransferQueueClicked(null);
        }
        if (Preferences.instance().getBoolean("browser.serialize")) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    MainController.this.sessions.load();
                }

                public void cleanup() {
                    for (Host host : MainController.this.sessions) {
                        MainController.newDocument().mount(host);
                    }
                    MainController.this.sessions.clear();
                }
            });
        }
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                BookmarkCollection.defaultCollection().load();
            }

            public void cleanup() {
                if (Preferences.instance().getBoolean("browser.openUntitled") && MainController.getBrowsers().isEmpty()) {
                    MainController.this.openDefaultBookmark(MainController.newDocument());
                }
                NSApplication.sharedApplication().setServicesProvider(MainController.this.id());
            }

            public String getActivity() {
                return "Loading Bookmarks";
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                HistoryCollection.defaultCollection().load();
            }

            public String getActivity() {
                return "Loading History";
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                TransferCollection.defaultCollection().load();
            }

            public String getActivity() {
                return "Loading Transfers";
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                Growl.instance().register();
            }

            public String getActivity() {
                return "Registering Growl";
            }
        });
        if (Preferences.instance().getBoolean("rendezvous.enable")) {
            RendezvousFactory.instance().addListener(new RendezvousListener(){

                public void serviceResolved(final String identifier, Host host) {
                    if (Preferences.instance().getBoolean("rendezvous.loopback.supress")) {
                        try {
                            if (InetAddress.getByName(host.getHostname()).equals(InetAddress.getLocalHost())) {
                                log.info((Object)("Supressed Rendezvous notification for " + host));
                                return;
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                    }
                    MainController.this.invoke((MainAction)new DefaultMainAction(){

                        public void run() {
                            Growl.instance().notifyWithImage("Bonjour", RendezvousFactory.instance().getDisplayedName(identifier), "rendezvous");
                        }
                    });
                }

                public void serviceLost(String servicename) {
                }
            });
        }
        if (Preferences.instance().getBoolean("defaulthandler.reminder") && Preferences.instance().getInteger("uses") > 0 && !URLSchemeHandlerConfiguration.instance().isDefaultHandlerForURLScheme(new String[]{Protocol.FTP.getScheme(), Protocol.FTP_TLS.getScheme(), Protocol.SFTP.getScheme()})) {
            NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Set Cyberduck as default application for FTP and SFTP locations?", (String)"Configuration"), Locale.localizedString((String)"As the default application, Cyberduck will open when you click on FTP or SFTP links in other applications, such as your web browser. You can change this setting in the Preferences later.", (String)"Configuration"), Locale.localizedString((String)"Change", (String)"Configuration"), null, Locale.localizedString((String)"Cancel", (String)"Configuration"));
            alert.setAlertStyle(1);
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(Locale.localizedString((String)"Don't ask again", (String)"Configuration"));
            int choice = alert.runModal();
            if (alert.suppressionButton().state() == 1) {
                Preferences.instance().setProperty("defaulthandler.reminder", false);
            }
            if (choice == 1) {
                URLSchemeHandlerConfiguration.instance().setDefaultHandlerForURLScheme(new String[]{Protocol.FTP.getScheme(), Protocol.FTP_TLS.getScheme(), Protocol.SFTP.getScheme()}, NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleIdentifier").toString());
            }
        }
        NSWorkspace.sharedWorkspace().notificationCenter().addObserver(this.id(), Foundation.selector("workspaceWillPowerOff:"), "NSWorkspaceWillPowerOffNotification", null);
        NSWorkspace.sharedWorkspace().notificationCenter().addObserver(this.id(), Foundation.selector("workspaceWillLogout:"), "NSWorkspaceSessionDidResignActiveNotification", null);
        NSWorkspace.sharedWorkspace().notificationCenter().addObserver(this.id(), Foundation.selector("workspaceWillSleep:"), "NSWorkspaceWillSleepNotification", null);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("applicationWillRestartAfterUpdate:"), "SUUpdaterWillRestartNotificationName", null);
        if (Preferences.instance().getBoolean("rendezvous.enable")) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    RendezvousFactory.instance().init();
                }
            });
        }
        this.background((BackgroundAction)new AbstractBackgroundAction(){
            private List<ThirdpartyBookmarkCollection> bookmarks = Collections.emptyList();

            public void run() {
                this.bookmarks = this.getThirdpartyBookmarks();
                for (ThirdpartyBookmarkCollection c : this.bookmarks) {
                    if (Preferences.instance().getBoolean(c.getConfiguration())) continue;
                    if (!c.isInstalled()) {
                        log.info((Object)("No application installed for " + c.getBundleIdentifier()));
                        continue;
                    }
                    c.load();
                    if (!c.isEmpty()) continue;
                    Preferences.instance().setProperty(c.getConfiguration(), true);
                }
            }

            public void cleanup() {
                for (ThirdpartyBookmarkCollection c : this.bookmarks) {
                    if (Preferences.instance().getBoolean(c.getConfiguration()) || c.isEmpty()) continue;
                    NSAlert alert = NSAlert.alert(MessageFormat.format(Locale.localizedString((String)"Import {0} Bookmarks", (String)"Configuration"), c.getName()), MessageFormat.format(Locale.localizedString((String)"{0} bookmarks found. Do you want to add these to your bookmarks?", (String)"Configuration"), c.size()), Locale.localizedString((String)"Import", (String)"Configuration"), null, Locale.localizedString((String)"Cancel", (String)"Configuration"));
                    alert.setShowsSuppressionButton(true);
                    alert.suppressionButton().setTitle(Locale.localizedString((String)"Don't ask again", (String)"Configuration"));
                    alert.setAlertStyle(1);
                    int choice = alert.runModal();
                    if (alert.suppressionButton().state() == 1) {
                        Preferences.instance().setProperty(c.getConfiguration(), true);
                    }
                    if (choice != 1) continue;
                    BookmarkCollection.defaultCollection().addAll((Collection)c);
                    Preferences.instance().setProperty(c.getConfiguration(), true);
                }
            }

            public String getActivity() {
                return "Loading thirdparty bookmarks";
            }

            private List<ThirdpartyBookmarkCollection> getThirdpartyBookmarks() {
                return Arrays.asList(new TransmitBookmarkCollection(), new FilezillaBookmarkCollection(), new FetchBookmarkCollection(), new FlowBookmarkCollection(), new InterarchyBookmarkCollection(), new CrossFtpBookmarkCollection(), new FireFtpBookmarkCollection());
            }
        });
    }

    public void serviceUploadFileUrl_(NSPasteboard pboard, String userData) {
        NSObject o;
        log.debug((Object)("serviceUploadFileUrl_:" + userData));
        if (pboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null) {
            NSArray elements = Rococoa.cast(o, NSArray.class);
            ArrayList<Local> files = new ArrayList<Local>();
            for (int i = 0; i < elements.count().intValue(); ++i) {
                files.add(LocalFactory.createLocal((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
            }
            this.upload(files);
        }
    }

    @Override
    public NSUInteger applicationShouldTerminate(NSApplication app) {
        log.debug((Object)"applicationShouldTerminate");
        NSUInteger result = TransferController.applicationShouldTerminate(app);
        if (!result.equals((Object)NSApplication.NSTerminateNow)) {
            return result;
        }
        for (BrowserController controller : MainController.getBrowsers()) {
            if (Preferences.instance().getBoolean("browser.serialize") && controller.isMounted()) {
                Host serialized = new Host(controller.getSession().getHost().getAsDictionary());
                serialized.setWorkdir(controller.workdir().getAbsolute());
                this.sessions.add(serialized);
            }
            if (!controller.isConnected()) continue;
            if (Preferences.instance().getBoolean("browser.confirmDisconnect")) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Quit"), Locale.localizedString((String)"You are connected to at least one remote site. Do you want to review open browsers?"), Locale.localizedString((String)"Quit Anyway"), Locale.localizedString((String)"Cancel"), Locale.localizedString((String)"Review\u2026"));
                alert.setAlertStyle(0);
                alert.setShowsSuppressionButton(true);
                alert.suppressionButton().setTitle(Locale.localizedString((String)"Don't ask again", (String)"Configuration"));
                int choice = alert.runModal();
                if (alert.suppressionButton().state() == 1) {
                    Preferences.instance().setProperty("browser.confirmDisconnect", false);
                }
                if (choice == -1) {
                    this.sessions.clear();
                    return NSApplication.NSTerminateCancel;
                }
                if (choice == 0) {
                    result = BrowserController.applicationShouldTerminate(app);
                    if (NSApplication.NSTerminateNow.equals((Object)result)) {
                        return this.applicationShouldTerminateAfterDonationPrompt(app);
                    }
                    return result;
                }
                if (choice != 1) continue;
                return this.applicationShouldTerminateAfterDonationPrompt(app);
            }
            controller.unmount();
        }
        return this.applicationShouldTerminateAfterDonationPrompt(app);
    }

    public NSUInteger applicationShouldTerminateAfterDonationPrompt(final NSApplication app) {
        log.debug((Object)"applicationShouldTerminateAfterDonationPrompt");
        if (!this.donationPrompt) {
            return NSApplication.NSTerminateNow;
        }
        License l = LicenseFactory.find();
        if (!l.verify()) {
            String lastversion = Preferences.instance().getProperty("donate.reminder");
            if (NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleShortVersionString").toString().equals(lastversion)) {
                return NSApplication.NSTerminateNow;
            }
            Calendar nextreminder = Calendar.getInstance();
            nextreminder.setTimeInMillis(Preferences.instance().getLong("donate.reminder.date"));
            nextreminder.add(6, Preferences.instance().getInteger("y"));
            log.debug((Object)("Next reminder:" + nextreminder.getTime().toString()));
            if (nextreminder.getTime().after(new Date(System.currentTimeMillis()))) {
                return NSApplication.NSTerminateNow;
            }
            final int uses = Preferences.instance().getInteger("uses");
            this.donationController = new WindowController(){
                private NSButton neverShowDonationCheckbox;

                protected String getBundleName() {
                    return "Donate";
                }

                public void setNeverShowDonationCheckbox(NSButton neverShowDonationCheckbox) {
                    this.neverShowDonationCheckbox = neverShowDonationCheckbox;
                    this.neverShowDonationCheckbox.setTarget(this.id());
                    this.neverShowDonationCheckbox.setState(Preferences.instance().getProperty("donate.reminder").equals(NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleShortVersionString").toString()) ? 1 : 0);
                }

                public void awakeFromNib() {
                    this.window().setTitle(this.window().title() + " (" + uses + ")");
                    this.window().center();
                    this.window().makeKeyAndOrderFront(null);
                    super.awakeFromNib();
                }

                public void closeDonationSheet(NSButton sender) {
                    if (sender.tag() == 1) {
                        18.openUrl(Preferences.instance().getProperty("website.donate"));
                    }
                    this.terminate();
                }

                public void windowWillClose(NSNotification notification) {
                    this.terminate();
                    super.windowWillClose(notification);
                }

                private void terminate() {
                    if (this.neverShowDonationCheckbox.state() == 1) {
                        Preferences.instance().setProperty("donate.reminder", NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleShortVersionString").toString());
                    }
                    Preferences.instance().setProperty("donate.reminder.date", System.currentTimeMillis());
                    MainController.this.donationPrompt = false;
                    app.replyToApplicationShouldTerminate(true);
                }
            };
            this.donationController.loadBundle();
            return NSApplication.NSTerminateLater;
        }
        return NSApplication.NSTerminateNow;
    }

    @Override
    public void applicationWillTerminate(NSNotification notification) {
        log.debug((Object)"applicationWillTerminate");
        this.invalidate();
        if (Preferences.instance().getBoolean("rendezvous.enable")) {
            RendezvousFactory.instance().quit();
        }
        Preferences.instance().setProperty("uses", Preferences.instance().getInteger("uses") + 1);
        Preferences.instance().save();
    }

    public void applicationWillRestartAfterUpdate(ID updater) {
        this.donationPrompt = false;
    }

    public void workspaceWillPowerOff(NSNotification notification) {
        log.debug((Object)"workspaceWillPowerOff");
    }

    public void workspaceWillLogout(NSNotification notification) {
        log.debug((Object)"workspaceWillLogout");
    }

    public void workspaceWillSleep(NSNotification notification) {
        log.debug((Object)"workspaceWillSleep");
    }

    public static BrowserController newDocument() {
        return MainController.newDocument(false);
    }

    public static List<BrowserController> getBrowsers() {
        return browsers;
    }

    public static BrowserController getBrowser() {
        for (BrowserController browser : MainController.getBrowsers()) {
            if (!browser.window().isKeyWindow()) continue;
            return browser;
        }
        return null;
    }

    public static BrowserController newDocument(boolean force) {
        log.debug((Object)"newDocument");
        final List<BrowserController> browsers = MainController.getBrowsers();
        if (!force) {
            for (BrowserController controller : browsers) {
                if (controller.hasSession()) continue;
                controller.window().makeKeyAndOrderFront(null);
                return controller;
            }
        }
        final BrowserController controller = new BrowserController();
        controller.addListener(new WindowListener(){

            public void windowWillClose() {
                browsers.remove(controller);
            }
        });
        if (!browsers.isEmpty()) {
            controller.cascade();
        }
        controller.window().makeKeyAndOrderFront(null);
        browsers.add(controller);
        return controller;
    }

    public boolean application_delegateHandlesKey(NSApplication application, String key) {
        return key.equals("orderedBrowsers");
    }

    public NSArray orderedBrowsers() {
        NSMutableArray orderedDocs = NSMutableArray.array();
        for (BrowserController browser : MainController.getBrowsers()) {
            orderedDocs.addObject(browser.proxy());
        }
        return orderedDocs;
    }

    @Override
    public boolean applicationShouldTerminateAfterLastWindowClosed(NSApplication app) {
        return false;
    }

    public static String[] availableCharsets() {
        ch.cyberduck.core.Collection charsets = new ch.cyberduck.core.Collection();
        for (Charset charset : Charset.availableCharsets().values()) {
            String name = charset.displayName();
            if (name.startsWith("IBM") || name.startsWith("x-")) continue;
            charsets.add(name);
        }
        return charsets.toArray(new String[charsets.size()]);
    }

    @Override
    protected String getBundleName() {
        return "Main";
    }
}

