/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.sparkle.Updater;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.ToolbarWindowController;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSAppleScript;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import ch.cyberduck.ui.cocoa.model.FinderLocal;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import ch.cyberduck.ui.cocoa.odb.WatchEditor;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.cocoa.urlhandler.URLSchemeHandlerConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesController
extends ToolbarWindowController {
    private static Logger log = Logger.getLogger(PreferencesController.class);
    private static PreferencesController instance = null;
    private NSView panelGeneral;
    private NSView panelEditor;
    private NSView panelBrowser;
    private NSView panelTransfer;
    private NSView panelFTP;
    private NSView panelSFTP;
    private NSView panelS3;
    private NSView panelGoogle;
    private NSView panelBandwidth;
    private NSView panelAdvanced;
    private NSView panelUpdate;
    private NSView panelLanguage;
    private static final String TRANSFERMODE_AUTO = Locale.localizedString((String)"Auto");
    private static final String TRANSFERMODE_BINARY = Locale.localizedString((String)"Binary");
    private static final String TRANSFERMODE_ASCII = Locale.localizedString((String)"ASCII");
    private static final String UNIX_LINE_ENDINGS = Locale.localizedString((String)"Unix Line Endings (LF)");
    private static final String MAC_LINE_ENDINGS = Locale.localizedString((String)"Mac Line Endings (CR)");
    private static final String WINDOWS_LINE_ENDINGS = Locale.localizedString((String)"Windows Line Endings (CRLF)");
    private NSPopUpButton editorCombobox;
    private NSOpenPanel editorPathPanel;
    private ProxyController editorPathPanelDelegate = new EditorOpenPanelDelegate();
    private NSButton defaultEditorCheckbox;
    private NSPopUpButton bookmarkSizePopup;
    private NSButton openUntitledBrowserCheckbox;
    private NSButton browserSerializeCheckbox;
    private NSPopUpButton defaultBookmarkCombobox;
    private final CollectionListener<Host> bookmarkCollectionListener = new AbstractCollectionListener<Host>(){

        public void collectionItemAdded(final Host bookmark) {
            PreferencesController.this.invoke((MainAction)new WindowMainAction(PreferencesController.this){

                public void run() {
                    PreferencesController.this.defaultBookmarkCombobox.addItemWithTitle(bookmark.getNickname());
                    PreferencesController.this.defaultBookmarkCombobox.lastItem().setImage(IconCache.iconNamed("cyberduck-document", 16));
                    PreferencesController.this.defaultBookmarkCombobox.lastItem().setRepresentedObject(bookmark.getUuid());
                }
            });
        }

        public void collectionItemRemoved(final Host bookmark) {
            PreferencesController.this.invoke((MainAction)new WindowMainAction(PreferencesController.this){

                public void run() {
                    NSInteger i;
                    String selected = PreferencesController.this.defaultBookmarkCombobox.selectedItem().representedObject();
                    if (StringUtils.isNotEmpty((String)selected) && selected.equals(bookmark.getUuid())) {
                        Preferences.instance().deleteProperty("browser.defaultBookmark");
                    }
                    if ((i = PreferencesController.this.defaultBookmarkCombobox.menu().indexOfItemWithRepresentedObject(bookmark.getUuid())).intValue() == -1) {
                        return;
                    }
                    PreferencesController.this.defaultBookmarkCombobox.removeItemAtIndex(i);
                }
            });
        }
    };
    private NSPopUpButton encodingCombobox;
    private NSPopUpButton chmodUploadTypePopup;
    private NSPopUpButton chmodDownloadTypePopup;
    private NSButton chmodUploadCheckbox;
    private NSButton chmodUploadDefaultCheckbox;
    private NSButton chmodUploadCustomCheckbox;
    private NSButton chmodDownloadCheckbox;
    private NSButton chmodDownloadDefaultCheckbox;
    private NSButton chmodDownloadCustomCheckbox;
    private NSButton downerr;
    private NSButton downerw;
    private NSButton downerx;
    private NSButton dgroupr;
    private NSButton dgroupw;
    private NSButton dgroupx;
    private NSButton dotherr;
    private NSButton dotherw;
    private NSButton dotherx;
    public NSButton uownerr;
    public NSButton uownerw;
    public NSButton uownerx;
    public NSButton ugroupr;
    public NSButton ugroupw;
    public NSButton ugroupx;
    public NSButton uotherr;
    public NSButton uotherw;
    public NSButton uotherx;
    private NSButton preserveModificationDownloadCheckbox;
    private NSButton preserveModificationUploadCheckbox;
    private NSButton horizontalLinesCheckbox;
    private NSButton verticalLinesCheckbox;
    private NSButton alternatingRowBackgroundCheckbox;
    private NSButton infoWindowAsInspectorCheckbox;
    private NSPopUpButton downloadPathPopup;
    private static final String CHOOSE = Locale.localizedString((String)"Choose") + "\u2026";
    private final Local DEFAULT_DOWNLOAD_FOLDER = LocalFactory.createLocal((String)Preferences.instance().getProperty("queue.download.folder"));
    private NSOpenPanel downloadPathPanel;
    private NSPopUpButton transferPopup;
    private static final int USE_QUEUE_SESSION_INDEX = 0;
    private static final int USE_BROWSER_SESSION_INDEX = 1;
    private NSTextField anonymousField;
    private NSTextField textFileTypeRegexField;
    private NSButton downloadSkipButton;
    private NSButton downloadSkipRegexDefaultButton;
    private NSTextView downloadSkipRegexField;
    private NSButton uploadSkipButton;
    private NSButton uploadSkipRegexDefaultButton;
    private NSTextView uploadSkipRegexField;
    protected static NSDictionary RED_FONT = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSColor.redColor()), NSArray.arrayWithObjects("NSColor"));
    private NSTextField loginField;
    private NSButton keychainCheckbox;
    private NSButton doubleClickCheckbox;
    private NSButton returnKeyCheckbox;
    private NSButton showHiddenCheckbox;
    private NSButton bringQueueToFrontCheckbox;
    private NSButton bringQueueToBackCheckbox;
    private NSButton removeFromQueueCheckbox;
    private NSButton openAfterDownloadCheckbox;
    private NSPopUpButton duplicateDownloadCombobox;
    private NSButton duplicateDownloadOverwriteButton;
    private NSPopUpButton duplicateUploadCombobox;
    private NSButton duplicateUploadOverwriteButton;
    private NSButton uploadTemporaryFilenameButton;
    private NSPopUpButton protocolCombobox;
    private NSButton confirmDisconnectCheckbox;
    private NSPopUpButton sshTransfersCombobox;
    private NSPopUpButton defaultFTPHandlerCombobox;
    private NSPopUpButton defaultSFTPHandlerCombobox;
    private NSPopUpButton defaultDownloadThrottleCombobox;
    private NSPopUpButton defaultUploadThrottleCombobox;
    private NSButton updateCheckbox;
    private NSPopUpButton updateFeedPopup;
    private NSPopUpButton defaultBucketLocation;
    private NSPopUpButton defaultStorageClassPopup;
    private NSPopUpButton documentExportFormatPopup;
    private NSPopUpButton spreadsheetExportFormatPopup;
    private NSPopUpButton presentationExportFormatPopup;
    private NSButton convertUploadsCheckbox;
    private NSButton ocrUploadsCheckbox;
    private NSPopUpButton languagePopup;
    private NSPopUpButton useProxiesButton;
    private NSPopUpButton configureProxiesButton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PreferencesController instance() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == instance) {
                instance = new PreferencesController();
            }
            return instance;
        }
    }

    private PreferencesController() {
        this.loadBundle();
    }

    @Override
    protected String getBundleName() {
        return "Preferences";
    }

    public void setPanelUpdate(NSView v) {
        this.panelUpdate = v;
    }

    public void setPanelAdvanced(NSView v) {
        this.panelAdvanced = v;
    }

    public void setPanelBandwidth(NSView v) {
        this.panelBandwidth = v;
    }

    public void setPanelSFTP(NSView v) {
        this.panelSFTP = v;
    }

    public void setPanelFTP(NSView v) {
        this.panelFTP = v;
    }

    public void setPanelS3(NSView v) {
        this.panelS3 = v;
    }

    public void setPanelGoogle(NSView v) {
        this.panelGoogle = v;
    }

    public void setPanelTransfer(NSView v) {
        this.panelTransfer = v;
    }

    public void setPanelBrowser(NSView v) {
        this.panelBrowser = v;
    }

    public void setPanelGeneral(NSView v) {
        this.panelGeneral = v;
    }

    public void setPanelEditor(NSView v) {
        this.panelEditor = v;
    }

    public void setPanelLanguage(NSView v) {
        this.panelLanguage = v;
    }

    @Override
    protected List<NSView> getPanels() {
        ArrayList<NSView> views = new ArrayList<NSView>();
        views.add(this.panelGeneral);
        views.add(this.panelBrowser);
        views.add(this.panelTransfer);
        views.add(this.panelEditor);
        views.add(this.panelFTP);
        views.add(this.panelSFTP);
        views.add(this.panelS3);
        views.add(this.panelGoogle);
        views.add(this.panelBandwidth);
        views.add(this.panelAdvanced);
        if (null != Updater.getFeed()) {
            views.add(this.panelUpdate);
        }
        views.add(this.panelLanguage);
        return views;
    }

    @Override
    protected List<String> getPanelIdentifiers() {
        ArrayList<String> views = new ArrayList<String>();
        views.add("general");
        views.add("browser");
        views.add("queue");
        views.add("pencil");
        views.add("ftp");
        views.add("sftp");
        views.add("s3");
        views.add("google");
        views.add("bandwidth");
        views.add("connection");
        if (null != Updater.getFeed()) {
            views.add("update");
        }
        views.add("language");
        return views;
    }

    @Override
    protected void invalidate() {
        BookmarkCollection.defaultCollection().removeListener(this.bookmarkCollectionListener);
        super.invalidate();
        instance = null;
    }

    @Override
    public void setWindow(NSWindow window) {
        window.setExcludedFromWindowsMenu(true);
        window.setFrameAutosaveName("Preferences");
        super.setWindow(window);
    }

    @Override
    protected double getMaxWindowWidth() {
        return 800.0;
    }

    @Override
    public void awakeFromNib() {
        this.window.center();
        this.chmodDownloadTypePopupChanged(this.chmodDownloadTypePopup);
        this.chmodUploadTypePopupChanged(this.chmodUploadTypePopup);
        boolean chmodDownloadDefaultEnabled = Preferences.instance().getBoolean("queue.download.changePermissions") && Preferences.instance().getBoolean("queue.download.permissions.useDefault");
        this.downerr.setEnabled(chmodDownloadDefaultEnabled);
        this.downerr.setTarget(this.id());
        this.downerr.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.downerw.setEnabled(chmodDownloadDefaultEnabled);
        this.downerw.setTarget(this.id());
        this.downerw.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.downerx.setEnabled(chmodDownloadDefaultEnabled);
        this.downerx.setTarget(this.id());
        this.downerx.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dgroupr.setEnabled(chmodDownloadDefaultEnabled);
        this.dgroupr.setTarget(this.id());
        this.dgroupr.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dgroupw.setEnabled(chmodDownloadDefaultEnabled);
        this.dgroupw.setTarget(this.id());
        this.dgroupw.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dgroupx.setEnabled(chmodDownloadDefaultEnabled);
        this.dgroupx.setTarget(this.id());
        this.dgroupx.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dotherr.setEnabled(chmodDownloadDefaultEnabled);
        this.dotherr.setTarget(this.id());
        this.dotherr.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dotherw.setEnabled(chmodDownloadDefaultEnabled);
        this.dotherw.setTarget(this.id());
        this.dotherw.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dotherx.setEnabled(chmodDownloadDefaultEnabled);
        this.dotherx.setTarget(this.id());
        this.dotherx.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        boolean chmodUploadDefaultEnabled = Preferences.instance().getBoolean("queue.upload.changePermissions") && Preferences.instance().getBoolean("queue.upload.permissions.useDefault");
        this.uownerr.setEnabled(chmodUploadDefaultEnabled);
        this.uownerr.setTarget(this.id());
        this.uownerr.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uownerw.setEnabled(chmodUploadDefaultEnabled);
        this.uownerw.setTarget(this.id());
        this.uownerw.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uownerx.setEnabled(chmodUploadDefaultEnabled);
        this.uownerx.setTarget(this.id());
        this.uownerx.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.ugroupr.setEnabled(chmodUploadDefaultEnabled);
        this.ugroupr.setTarget(this.id());
        this.ugroupr.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.ugroupw.setEnabled(chmodUploadDefaultEnabled);
        this.ugroupw.setTarget(this.id());
        this.ugroupw.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.ugroupx.setEnabled(chmodUploadDefaultEnabled);
        this.ugroupx.setTarget(this.id());
        this.ugroupx.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uotherr.setEnabled(chmodUploadDefaultEnabled);
        this.uotherr.setTarget(this.id());
        this.uotherr.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uotherw.setEnabled(chmodUploadDefaultEnabled);
        this.uotherw.setTarget(this.id());
        this.uotherw.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uotherx.setEnabled(chmodUploadDefaultEnabled);
        this.uotherx.setTarget(this.id());
        this.uotherx.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        super.awakeFromNib();
    }

    public void setEditorCombobox(NSPopUpButton b) {
        this.editorCombobox = b;
        this.editorCombobox.setAutoenablesItems(false);
        this.updateEditorCombobox();
    }

    private void updateEditorCombobox() {
        this.editorCombobox.removeAllItems();
        Map<String, String> editors = EditorFactory.getSupportedEditors();
        Iterator<String> editorNames = editors.keySet().iterator();
        Iterator<String> editorIdentifiers = editors.values().iterator();
        while (editorNames.hasNext()) {
            this.addEditor(editorNames.next(), editorIdentifiers.next());
        }
        this.editorCombobox.setTarget(this.id());
        Selector action = Foundation.selector("editorComboboxClicked:");
        this.editorCombobox.setAction(action);
        if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
            this.editorCombobox.menu().addItem(NSMenuItem.separatorItem());
            this.editorCombobox.menu().addItemWithTitle_action_keyEquivalent(CHOOSE, action, "");
            this.editorCombobox.lastItem().setTarget(this.id());
        }
        this.editorCombobox.selectItemWithTitle(EditorFactory.getApplicationName(EditorFactory.defaultEditor()));
    }

    private void addEditor(String editor, String identifier) {
        this.editorCombobox.addItemWithTitle(editor);
        boolean enabled = EditorFactory.getInstalledEditors().containsValue(identifier);
        this.editorCombobox.itemWithTitle(editor).setEnabled(enabled);
        if (enabled) {
            this.editorCombobox.itemWithTitle(editor).setImage(IconCache.instance().iconForApplication(identifier, 16));
        }
    }

    public void editorComboboxClicked(NSPopUpButton sender) {
        if (sender.title().equals(CHOOSE)) {
            this.editorPathPanel = NSOpenPanel.openPanel();
            this.editorPathPanel.setDelegate(this.editorPathPanelDelegate.id());
            this.editorPathPanel.setAllowsMultipleSelection(false);
            this.editorPathPanel.setCanCreateDirectories(false);
            this.editorPathPanel.beginSheetForDirectory("/Applications", null, this.window, this.id(), Foundation.selector("editorPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            String selected = EditorFactory.getSupportedEditors().get(sender.titleOfSelectedItem());
            Preferences.instance().setProperty("editor.bundleIdentifier", selected);
            BrowserController.validateToolbarItems();
        }
    }

    public void editorPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        NSArray selected;
        String filename;
        if (returncode == 1 && (filename = (selected = sheet.filenames()).lastObject().toString()) != null) {
            String path = LocalFactory.createLocal((String)filename).getAbsolute();
            NSBundle app = NSBundle.bundleWithPath(path);
            if (null == app) {
                log.error((Object)("Loading bundle failed:" + path));
            } else {
                String bundleIdentifier = app.bundleIdentifier();
                if (!EditorFactory.getInstalledEditors().values().contains(bundleIdentifier)) {
                    WatchEditor.addInstalledEditor(EditorFactory.getApplicationName(bundleIdentifier), app.bundleIdentifier());
                }
                Preferences.instance().setProperty("editor.bundleIdentifier", bundleIdentifier);
                BrowserController.validateToolbarItems();
            }
        }
        this.updateEditorCombobox();
    }

    public void setDefaultEditorCheckbox(NSButton b) {
        this.defaultEditorCheckbox = b;
        this.defaultEditorCheckbox.setTarget(this.id());
        this.defaultEditorCheckbox.setAction(Foundation.selector("defaultEditorCheckboxClicked:"));
        this.defaultEditorCheckbox.setState(Preferences.instance().getBoolean("editor.alwaysUseDefault") ? 1 : 0);
    }

    public void defaultEditorCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("editor.alwaysUseDefault", enabled);
    }

    public void setBookmarkSizePopup(NSPopUpButton b) {
        this.bookmarkSizePopup = b;
        this.bookmarkSizePopup.setTarget(this.id());
        this.bookmarkSizePopup.setAction(Foundation.selector("bookmarkSizePopupClicked:"));
        int size = Preferences.instance().getInteger("bookmark.icon.size");
        for (int i = 0; i < this.bookmarkSizePopup.numberOfItems().intValue(); ++i) {
            this.bookmarkSizePopup.itemAtIndex(new NSInteger(i)).setState(0);
        }
        if (16 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(new NSInteger(0L));
        }
        if (32 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(new NSInteger(1L));
        }
        if (64 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(new NSInteger(2L));
        }
    }

    public void bookmarkSizePopupClicked(NSPopUpButton sender) {
        if (sender.indexOfSelectedItem().intValue() == 0) {
            Preferences.instance().setProperty("bookmark.icon.size", 16);
        }
        if (sender.indexOfSelectedItem().intValue() == 1) {
            Preferences.instance().setProperty("bookmark.icon.size", 32);
        }
        if (sender.indexOfSelectedItem().intValue() == 2) {
            Preferences.instance().setProperty("bookmark.icon.size", 64);
        }
        BrowserController.updateBookmarkTableRowHeight();
    }

    public void setOpenUntitledBrowserCheckbox(NSButton b) {
        this.defaultEditorCheckbox = b;
        this.defaultEditorCheckbox.setTarget(this.id());
        this.defaultEditorCheckbox.setAction(Foundation.selector("openUntitledBrowserCheckboxClicked:"));
        this.defaultEditorCheckbox.setState(Preferences.instance().getBoolean("browser.openUntitled") ? 1 : 0);
    }

    public void openUntitledBrowserCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.openUntitled", enabled);
    }

    public void setBrowserSerializeCheckbox(NSButton b) {
        this.browserSerializeCheckbox = b;
        this.browserSerializeCheckbox.setTarget(this.id());
        this.browserSerializeCheckbox.setAction(Foundation.selector("browserSerializeCheckboxClicked:"));
        this.browserSerializeCheckbox.setState(Preferences.instance().getBoolean("browser.serialize") ? 1 : 0);
    }

    public void browserSerializeCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.serialize", enabled);
    }

    public void setDefaultBookmarkCombobox(NSPopUpButton b) {
        this.defaultBookmarkCombobox = b;
        this.defaultBookmarkCombobox.setToolTip(Locale.localizedString((String)"Bookmarks"));
        this.defaultBookmarkCombobox.removeAllItems();
        this.defaultBookmarkCombobox.addItemWithTitle(Locale.localizedString((String)"None"));
        this.defaultBookmarkCombobox.selectItem(this.defaultBookmarkCombobox.lastItem());
        this.defaultBookmarkCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Host bookmark : BookmarkCollection.defaultCollection()) {
            this.defaultBookmarkCombobox.addItemWithTitle(bookmark.getNickname());
            this.defaultBookmarkCombobox.lastItem().setImage(IconCache.iconNamed(bookmark.getProtocol().icon(), 16));
            this.defaultBookmarkCombobox.lastItem().setRepresentedObject(bookmark.getUuid());
            if (!bookmark.getUuid().equals(Preferences.instance().getProperty("browser.defaultBookmark"))) continue;
            this.defaultBookmarkCombobox.selectItem(this.defaultBookmarkCombobox.lastItem());
        }
        BookmarkCollection.defaultCollection().addListener(this.bookmarkCollectionListener);
        this.defaultBookmarkCombobox.setTarget(this.id());
        Selector action = Foundation.selector("defaultBookmarkComboboxClicked:");
        this.defaultBookmarkCombobox.setAction(action);
    }

    public void defaultBookmarkComboboxClicked(NSPopUpButton sender) {
        String selected = sender.selectedItem().representedObject();
        if (null == selected) {
            Preferences.instance().deleteProperty("browser.defaultBookmark");
        }
        Preferences.instance().setProperty("browser.defaultBookmark", selected);
    }

    public void setEncodingCombobox(NSPopUpButton b) {
        this.encodingCombobox = b;
        this.encodingCombobox.setTarget(this.id());
        this.encodingCombobox.setAction(Foundation.selector("encodingComboboxClicked:"));
        this.encodingCombobox.removeAllItems();
        this.encodingCombobox.addItemsWithTitles(NSArray.arrayWithObjects(MainController.availableCharsets()));
        this.encodingCombobox.selectItemWithTitle(Preferences.instance().getProperty("browser.charset.encoding"));
    }

    public void encodingComboboxClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("browser.charset.encoding", sender.titleOfSelectedItem());
    }

    public void setChmodUploadTypePopup(NSPopUpButton b) {
        this.chmodUploadTypePopup = b;
        this.chmodUploadTypePopup.selectItemAtIndex(new NSInteger(0L));
        this.chmodUploadTypePopup.setTarget(this.id());
        this.chmodUploadTypePopup.setAction(Foundation.selector("chmodUploadTypePopupChanged:"));
    }

    public void chmodUploadTypePopupChanged(NSPopUpButton sender) {
        Permission p = null;
        if (sender.selectedItem().tag() == 0) {
            p = new Permission(Preferences.instance().getInteger("queue.upload.permissions.file.default"));
        }
        if (sender.selectedItem().tag() == 1) {
            p = new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default"));
        }
        if (null == p) {
            log.error((Object)("No selected item for:" + sender));
            return;
        }
        boolean[] ownerPerm = p.getOwnerPermissions();
        boolean[] groupPerm = p.getGroupPermissions();
        boolean[] otherPerm = p.getOtherPermissions();
        this.uownerr.setState(ownerPerm[0] ? 1 : 0);
        this.uownerw.setState(ownerPerm[1] ? 1 : 0);
        this.uownerx.setState(ownerPerm[2] ? 1 : 0);
        this.ugroupr.setState(groupPerm[0] ? 1 : 0);
        this.ugroupw.setState(groupPerm[1] ? 1 : 0);
        this.ugroupx.setState(groupPerm[2] ? 1 : 0);
        this.uotherr.setState(otherPerm[0] ? 1 : 0);
        this.uotherw.setState(otherPerm[1] ? 1 : 0);
        this.uotherx.setState(otherPerm[2] ? 1 : 0);
    }

    public void setChmodDownloadTypePopup(NSPopUpButton b) {
        this.chmodDownloadTypePopup = b;
        this.chmodDownloadTypePopup.selectItemAtIndex(new NSInteger(0L));
        this.chmodDownloadTypePopup.setTarget(this.id());
        this.chmodDownloadTypePopup.setAction(Foundation.selector("chmodDownloadTypePopupChanged:"));
    }

    public void chmodDownloadTypePopupChanged(NSPopUpButton sender) {
        Permission p = null;
        if (sender.selectedItem().tag() == 0) {
            p = new Permission(Preferences.instance().getInteger("queue.download.permissions.file.default"));
        }
        if (sender.selectedItem().tag() == 1) {
            p = new Permission(Preferences.instance().getInteger("queue.download.permissions.folder.default"));
        }
        if (null == p) {
            log.error((Object)("No selected item for:" + sender));
            return;
        }
        boolean[] ownerPerm = p.getOwnerPermissions();
        boolean[] groupPerm = p.getGroupPermissions();
        boolean[] otherPerm = p.getOtherPermissions();
        this.downerr.setState(ownerPerm[0] ? 1 : 0);
        this.downerw.setState(ownerPerm[1] ? 1 : 0);
        this.downerx.setState(ownerPerm[2] ? 1 : 0);
        this.dgroupr.setState(groupPerm[0] ? 1 : 0);
        this.dgroupw.setState(groupPerm[1] ? 1 : 0);
        this.dgroupx.setState(groupPerm[2] ? 1 : 0);
        this.dotherr.setState(otherPerm[0] ? 1 : 0);
        this.dotherw.setState(otherPerm[1] ? 1 : 0);
        this.dotherx.setState(otherPerm[2] ? 1 : 0);
    }

    public void setChmodUploadCheckbox(NSButton b) {
        this.chmodUploadCheckbox = b;
        this.chmodUploadCheckbox.setTarget(this.id());
        this.chmodUploadCheckbox.setAction(Foundation.selector("chmodUploadCheckboxClicked:"));
        this.chmodUploadCheckbox.setState(Preferences.instance().getBoolean("queue.upload.changePermissions") ? 1 : 0);
    }

    public void chmodUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.changePermissions", enabled);
        this.chmodUploadDefaultCheckbox.setEnabled(enabled);
        this.chmodUploadCustomCheckbox.setEnabled(enabled);
        boolean chmodUploadDefaultChecked = this.chmodUploadDefaultCheckbox.state() == 1;
        this.uownerr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uownerw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uownerx.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupx.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherx.setEnabled(enabled && chmodUploadDefaultChecked);
    }

    public void setChmodUploadDefaultCheckbox(NSButton b) {
        this.chmodUploadDefaultCheckbox = b;
        this.chmodUploadDefaultCheckbox.setTarget(this.id());
        this.chmodUploadDefaultCheckbox.setAction(Foundation.selector("chmodUploadDefaultCheckboxClicked:"));
        this.chmodUploadDefaultCheckbox.setState(Preferences.instance().getBoolean("queue.upload.permissions.useDefault") ? 1 : 0);
        this.chmodUploadDefaultCheckbox.setEnabled(Preferences.instance().getBoolean("queue.upload.changePermissions"));
    }

    public void chmodUploadDefaultCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.permissions.useDefault", enabled);
        this.uownerr.setEnabled(enabled);
        this.uownerw.setEnabled(enabled);
        this.uownerx.setEnabled(enabled);
        this.ugroupr.setEnabled(enabled);
        this.ugroupw.setEnabled(enabled);
        this.ugroupx.setEnabled(enabled);
        this.uotherr.setEnabled(enabled);
        this.uotherw.setEnabled(enabled);
        this.uotherx.setEnabled(enabled);
        this.chmodUploadCustomCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodUploadCustomCheckbox(NSButton b) {
        this.chmodUploadCustomCheckbox = b;
        this.chmodUploadCustomCheckbox.setTarget(this.id());
        this.chmodUploadCustomCheckbox.setAction(Foundation.selector("chmodUploadCustomCheckboxClicked:"));
        this.chmodUploadCustomCheckbox.setState(!Preferences.instance().getBoolean("queue.upload.permissions.useDefault") ? 1 : 0);
        this.chmodUploadCustomCheckbox.setEnabled(Preferences.instance().getBoolean("queue.upload.changePermissions"));
    }

    public void chmodUploadCustomCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.permissions.useDefault", !enabled);
        this.uownerr.setEnabled(!enabled);
        this.uownerw.setEnabled(!enabled);
        this.uownerx.setEnabled(!enabled);
        this.ugroupr.setEnabled(!enabled);
        this.ugroupw.setEnabled(!enabled);
        this.ugroupx.setEnabled(!enabled);
        this.uotherr.setEnabled(!enabled);
        this.uotherw.setEnabled(!enabled);
        this.uotherx.setEnabled(!enabled);
        this.chmodUploadDefaultCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodDownloadCheckbox(NSButton b) {
        this.chmodDownloadCheckbox = b;
        this.chmodDownloadCheckbox.setTarget(this.id());
        this.chmodDownloadCheckbox.setAction(Foundation.selector("chmodDownloadCheckboxClicked:"));
        this.chmodDownloadCheckbox.setState(Preferences.instance().getBoolean("queue.download.changePermissions") ? 1 : 0);
    }

    public void chmodDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.changePermissions", enabled);
        this.chmodDownloadDefaultCheckbox.setEnabled(enabled);
        this.chmodDownloadCustomCheckbox.setEnabled(enabled);
        boolean chmodDownloadDefaultChecked = this.chmodDownloadDefaultCheckbox.state() == 1;
        this.downerr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.downerw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.downerx.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupx.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherx.setEnabled(enabled && chmodDownloadDefaultChecked);
    }

    public void setChmodDownloadDefaultCheckbox(NSButton b) {
        this.chmodDownloadDefaultCheckbox = b;
        this.chmodDownloadDefaultCheckbox.setTarget(this.id());
        this.chmodDownloadDefaultCheckbox.setAction(Foundation.selector("chmodDownloadDefaultCheckboxClicked:"));
        this.chmodDownloadDefaultCheckbox.setState(Preferences.instance().getBoolean("queue.download.permissions.useDefault") ? 1 : 0);
        this.chmodDownloadDefaultCheckbox.setEnabled(Preferences.instance().getBoolean("queue.download.changePermissions"));
    }

    public void chmodDownloadDefaultCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.permissions.useDefault", enabled);
        this.downerr.setEnabled(enabled);
        this.downerw.setEnabled(enabled);
        this.downerx.setEnabled(enabled);
        this.dgroupr.setEnabled(enabled);
        this.dgroupw.setEnabled(enabled);
        this.dgroupx.setEnabled(enabled);
        this.dotherr.setEnabled(enabled);
        this.dotherw.setEnabled(enabled);
        this.dotherx.setEnabled(enabled);
        this.chmodDownloadCustomCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodDownloadCustomCheckbox(NSButton b) {
        this.chmodDownloadCustomCheckbox = b;
        this.chmodDownloadCustomCheckbox.setTarget(this.id());
        this.chmodDownloadCustomCheckbox.setAction(Foundation.selector("chmodDownloadCustomCheckboxClicked:"));
        this.chmodDownloadCustomCheckbox.setState(!Preferences.instance().getBoolean("queue.download.permissions.useDefault") ? 1 : 0);
        this.chmodDownloadCustomCheckbox.setEnabled(Preferences.instance().getBoolean("queue.download.changePermissions"));
    }

    public void chmodDownloadCustomCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.permissions.useDefault", !enabled);
        this.downerr.setEnabled(!enabled);
        this.downerw.setEnabled(!enabled);
        this.downerx.setEnabled(!enabled);
        this.dgroupr.setEnabled(!enabled);
        this.dgroupw.setEnabled(!enabled);
        this.dgroupx.setEnabled(!enabled);
        this.dotherr.setEnabled(!enabled);
        this.dotherw.setEnabled(!enabled);
        this.dotherx.setEnabled(!enabled);
        this.chmodDownloadDefaultCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setDownerr(NSButton downerr) {
        this.downerr = downerr;
    }

    public void setDownerw(NSButton downerw) {
        this.downerw = downerw;
    }

    public void setDownerx(NSButton downerx) {
        this.downerx = downerx;
    }

    public void setDgroupr(NSButton dgroupr) {
        this.dgroupr = dgroupr;
    }

    public void setDgroupw(NSButton dgroupw) {
        this.dgroupw = dgroupw;
    }

    public void setDgroupx(NSButton dgroupx) {
        this.dgroupx = dgroupx;
    }

    public void setDotherr(NSButton dotherr) {
        this.dotherr = dotherr;
    }

    public void setDotherw(NSButton dotherw) {
        this.dotherw = dotherw;
    }

    public void setDotherx(NSButton dotherx) {
        this.dotherx = dotherx;
    }

    public void setUownerr(NSButton uownerr) {
        this.uownerr = uownerr;
    }

    public void setUownerw(NSButton uownerw) {
        this.uownerw = uownerw;
    }

    public void setUownerx(NSButton uownerx) {
        this.uownerx = uownerx;
    }

    public void setUgroupr(NSButton ugroupr) {
        this.ugroupr = ugroupr;
    }

    public void setUgroupw(NSButton ugroupw) {
        this.ugroupw = ugroupw;
    }

    public void setUgroupx(NSButton ugroupx) {
        this.ugroupx = ugroupx;
    }

    public void setUotherr(NSButton uotherr) {
        this.uotherr = uotherr;
    }

    public void setUotherw(NSButton uotherw) {
        this.uotherw = uotherw;
    }

    public void setUotherx(NSButton uotherx) {
        this.uotherx = uotherx;
    }

    public void defaultPermissionsDownloadChanged(ID sender) {
        boolean[][] p = new boolean[3][3];
        p[0][0] = this.downerr.state() == 1;
        p[0][1] = this.downerw.state() == 1;
        p[0][2] = this.downerx.state() == 1;
        p[1][0] = this.dgroupr.state() == 1;
        p[1][1] = this.dgroupw.state() == 1;
        p[1][2] = this.dgroupx.state() == 1;
        p[2][0] = this.dotherr.state() == 1;
        p[2][1] = this.dotherw.state() == 1;
        p[2][2] = this.dotherx.state() == 1;
        Permission permission = new Permission(p);
        if (this.chmodDownloadTypePopup.selectedItem().tag() == 0) {
            Preferences.instance().setProperty("queue.download.permissions.file.default", permission.getOctalString());
        }
        if (this.chmodDownloadTypePopup.selectedItem().tag() == 1) {
            Preferences.instance().setProperty("queue.download.permissions.folder.default", permission.getOctalString());
        }
    }

    public void defaultPermissionsUploadChanged(NSButton sender) {
        boolean[][] p = new boolean[3][3];
        p[0][0] = this.uownerr.state() == 1;
        p[0][1] = this.uownerw.state() == 1;
        p[0][2] = this.uownerx.state() == 1;
        p[1][0] = this.ugroupr.state() == 1;
        p[1][1] = this.ugroupw.state() == 1;
        p[1][2] = this.ugroupx.state() == 1;
        p[2][0] = this.uotherr.state() == 1;
        p[2][1] = this.uotherw.state() == 1;
        p[2][2] = this.uotherx.state() == 1;
        Permission permission = new Permission(p);
        if (this.chmodUploadTypePopup.selectedItem().tag() == 0) {
            Preferences.instance().setProperty("queue.upload.permissions.file.default", permission.getOctalString());
        }
        if (this.chmodUploadTypePopup.selectedItem().tag() == 1) {
            Preferences.instance().setProperty("queue.upload.permissions.folder.default", permission.getOctalString());
        }
    }

    public void setPreserveModificationDownloadCheckbox(NSButton b) {
        this.preserveModificationDownloadCheckbox = b;
        this.preserveModificationDownloadCheckbox.setTarget(this.id());
        this.preserveModificationDownloadCheckbox.setAction(Foundation.selector("preserveModificationDownloadCheckboxClicked:"));
        this.preserveModificationDownloadCheckbox.setState(Preferences.instance().getBoolean("queue.download.preserveDate") ? 1 : 0);
    }

    public void preserveModificationDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.preserveDate", enabled);
    }

    public void setPreserveModificationUploadCheckbox(NSButton b) {
        this.preserveModificationUploadCheckbox = b;
        this.preserveModificationUploadCheckbox.setTarget(this.id());
        this.preserveModificationUploadCheckbox.setAction(Foundation.selector("preserveModificationUploadCheckboxClicked:"));
        this.preserveModificationUploadCheckbox.setState(Preferences.instance().getBoolean("queue.upload.preserveDate") ? 1 : 0);
    }

    public void preserveModificationUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.preserveDate", enabled);
    }

    public void setHorizontalLinesCheckbox(NSButton b) {
        this.horizontalLinesCheckbox = b;
        this.horizontalLinesCheckbox.setTarget(this.id());
        this.horizontalLinesCheckbox.setAction(Foundation.selector("horizontalLinesCheckboxClicked:"));
        this.horizontalLinesCheckbox.setState(Preferences.instance().getBoolean("browser.horizontalLines") ? 1 : 0);
    }

    public void horizontalLinesCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.horizontalLines", enabled);
        BrowserController.updateBrowserTableAttributes();
    }

    public void setVerticalLinesCheckbox(NSButton b) {
        this.verticalLinesCheckbox = b;
        this.verticalLinesCheckbox.setTarget(this.id());
        this.verticalLinesCheckbox.setAction(Foundation.selector("verticalLinesCheckboxClicked:"));
        this.verticalLinesCheckbox.setState(Preferences.instance().getBoolean("browser.verticalLines") ? 1 : 0);
    }

    public void verticalLinesCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.verticalLines", enabled);
        BrowserController.updateBrowserTableAttributes();
    }

    public void setAlternatingRowBackgroundCheckbox(NSButton b) {
        this.alternatingRowBackgroundCheckbox = b;
        this.alternatingRowBackgroundCheckbox.setTarget(this.id());
        this.alternatingRowBackgroundCheckbox.setAction(Foundation.selector("alternatingRowBackgroundCheckboxClicked:"));
        this.alternatingRowBackgroundCheckbox.setState(Preferences.instance().getBoolean("browser.alternatingRows") ? 1 : 0);
    }

    public void alternatingRowBackgroundCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.alternatingRows", enabled);
        BrowserController.updateBrowserTableAttributes();
    }

    public void setInfoWindowAsInspectorCheckbox(NSButton b) {
        this.infoWindowAsInspectorCheckbox = b;
        this.infoWindowAsInspectorCheckbox.setTarget(this.id());
        this.infoWindowAsInspectorCheckbox.setAction(Foundation.selector("infoWindowAsInspectorCheckboxClicked:"));
        this.infoWindowAsInspectorCheckbox.setState(Preferences.instance().getBoolean("browser.info.isInspector") ? 1 : 0);
    }

    public void infoWindowAsInspectorCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.info.isInspector", enabled);
    }

    public void setDownloadPathPopup(NSPopUpButton b) {
        this.downloadPathPopup = b;
        this.downloadPathPopup.setTarget(this.id());
        Selector action = Foundation.selector("downloadPathPopupClicked:");
        this.downloadPathPopup.setAction(action);
        this.downloadPathPopup.removeAllItems();
        this.addDownloadPath(action, this.DEFAULT_DOWNLOAD_FOLDER);
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Desktop"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Downloads"));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(CHOOSE, action, "");
        this.downloadPathPopup.lastItem().setTarget(this.id());
    }

    private void addDownloadPath(Selector action, Local f) {
        this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(f.getDisplayName(), action, "");
        this.downloadPathPopup.lastItem().setTarget(this.id());
        this.downloadPathPopup.lastItem().setImage(IconCache.instance().iconForPath(f, (Integer)16));
        this.downloadPathPopup.lastItem().setRepresentedObject(f.getAbsolute());
        if (this.DEFAULT_DOWNLOAD_FOLDER.equals((Object)f)) {
            this.downloadPathPopup.selectItem(this.downloadPathPopup.lastItem());
        }
    }

    public void downloadPathPopupClicked(NSMenuItem sender) {
        if (sender.title().equals(CHOOSE)) {
            this.downloadPathPanel = NSOpenPanel.openPanel();
            this.downloadPathPanel.setCanChooseFiles(false);
            this.downloadPathPanel.setCanChooseDirectories(true);
            this.downloadPathPanel.setAllowsMultipleSelection(false);
            this.downloadPathPanel.setCanCreateDirectories(true);
            this.downloadPathPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector("downloadPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            Preferences.instance().setProperty("queue.download.folder", LocalFactory.createLocal((String)sender.representedObject()).getAbbreviatedPath());
        }
    }

    public void downloadPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        NSArray selected;
        String filename;
        if (returncode == 1 && (filename = (selected = sheet.filenames()).lastObject().toString()) != null) {
            Preferences.instance().setProperty("queue.download.folder", LocalFactory.createLocal((String)filename).getAbbreviatedPath());
        }
        Local custom = LocalFactory.createLocal((String)Preferences.instance().getProperty("queue.download.folder"));
        this.downloadPathPopup.itemAtIndex(new NSInteger(0L)).setTitle(custom.getDisplayName());
        this.downloadPathPopup.itemAtIndex(new NSInteger(0L)).setRepresentedObject(custom.getAbsolute());
        this.downloadPathPopup.itemAtIndex(new NSInteger(0L)).setImage(IconCache.instance().iconForPath(custom, (Integer)16));
        this.downloadPathPopup.selectItemAtIndex(new NSInteger(0L));
        this.downloadPathPanel = null;
    }

    public void setTransferPopup(NSPopUpButton b) {
        this.transferPopup = b;
        this.transferPopup.setTarget(this.id());
        this.transferPopup.setAction(Foundation.selector("transferPopupClicked:"));
        this.transferPopup.selectItemAtIndex(new NSInteger(Preferences.instance().getInteger("connection.host.max") == 1 ? 1L : 0L));
    }

    public void transferPopupClicked(NSPopUpButton sender) {
        if (sender.indexOfSelectedItem().intValue() == 1) {
            Preferences.instance().setProperty("connection.host.max", 1);
        } else if (sender.indexOfSelectedItem().intValue() == 0) {
            Preferences.instance().setProperty("connection.host.max", -1);
        }
    }

    public void setAnonymousField(NSTextField f) {
        this.anonymousField = f;
        this.anonymousField.setStringValue(Preferences.instance().getProperty("connection.login.anon.pass"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("anonymousFieldDidChange:"), "NSControlTextDidChangeNotification", this.anonymousField);
    }

    public void anonymousFieldDidChange(NSNotification sender) {
        Preferences.instance().setProperty("connection.login.anon.pass", this.anonymousField.stringValue());
    }

    public void setTextFileTypeRegexField(NSTextField f) {
        this.textFileTypeRegexField = f;
        this.textFileTypeRegexField.setStringValue(Preferences.instance().getProperty("filetype.text.regex"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("textFileTypeRegexFieldDidChange:"), "NSControlTextDidChangeNotification", this.textFileTypeRegexField);
    }

    public void textFileTypeRegexFieldDidChange(NSNotification sender) {
        String value = this.textFileTypeRegexField.stringValue().trim();
        try {
            Pattern compiled = Pattern.compile(value);
            this.textFileTypeRegexField.setTextColor(NSColor.controlTextColor());
            Preferences.instance().setProperty("filetype.text.regex", compiled.pattern());
        }
        catch (PatternSyntaxException e) {
            this.textFileTypeRegexField.setTextColor(NSColor.redColor());
        }
    }

    public void setDownloadSkipButton(NSButton b) {
        this.downloadSkipButton = b;
        this.downloadSkipButton.setTarget(this.id());
        this.downloadSkipButton.setAction(Foundation.selector("downloadSkipButtonClicked:"));
        this.downloadSkipButton.setState(Preferences.instance().getBoolean("queue.download.skip.enable") ? 1 : 0);
    }

    public void downloadSkipButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.downloadSkipRegexField.setSelectable(enabled);
        this.downloadSkipRegexField.setEditable(enabled);
        this.downloadSkipRegexField.setTextColor(enabled ? NSColor.controlTextColor() : NSColor.disabledControlTextColor());
        Preferences.instance().setProperty("queue.download.skip.enable", enabled);
    }

    public void setDownloadSkipRegexDefaultButton(NSButton b) {
        this.downloadSkipRegexDefaultButton = b;
        this.downloadSkipRegexDefaultButton.setTarget(this.id());
        this.downloadSkipRegexDefaultButton.setAction(Foundation.selector("downloadSkipRegexDefaultButtonClicked:"));
    }

    public void downloadSkipRegexDefaultButtonClicked(NSButton sender) {
        String regex = Preferences.instance().getProperty("queue.download.skip.regex.default");
        this.downloadSkipRegexField.setString(regex);
        Preferences.instance().setProperty("queue.download.skip.regex", regex);
    }

    public void setDownloadSkipRegexField(NSTextView t) {
        this.downloadSkipRegexField = t;
        this.downloadSkipRegexField.setFont(NSFont.userFixedPitchFontOfSize(9.0));
        this.downloadSkipRegexField.setString(Preferences.instance().getProperty("queue.download.skip.regex"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("downloadSkipRegexFieldDidChange:"), "NSTextDidChangeNotification", this.downloadSkipRegexField);
    }

    public void downloadSkipRegexFieldDidChange(NSNotification sender) {
        String value = this.downloadSkipRegexField.string().trim();
        if ("".equals(value)) {
            Preferences.instance().setProperty("queue.download.skip.enable", false);
            Preferences.instance().setProperty("queue.download.skip.regex", value);
            this.downloadSkipButton.setState(0);
        }
        try {
            Pattern compiled = Pattern.compile(value);
            Preferences.instance().setProperty("queue.download.skip.regex", compiled.pattern());
            this.mark(this.downloadSkipRegexField.textStorage(), null);
        }
        catch (PatternSyntaxException e) {
            this.mark(this.downloadSkipRegexField.textStorage(), e);
        }
    }

    public void setUploadSkipButton(NSButton b) {
        this.uploadSkipButton = b;
        this.uploadSkipButton.setTarget(this.id());
        this.uploadSkipButton.setAction(Foundation.selector("uploadSkipButtonClicked:"));
        this.uploadSkipButton.setState(Preferences.instance().getBoolean("queue.upload.skip.enable") ? 1 : 0);
    }

    public void uploadSkipButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.uploadSkipRegexField.setSelectable(enabled);
        this.uploadSkipRegexField.setEditable(enabled);
        this.uploadSkipRegexField.setTextColor(enabled ? NSColor.controlTextColor() : NSColor.disabledControlTextColor());
        Preferences.instance().setProperty("queue.upload.skip.enable", enabled);
    }

    public void setUploadSkipRegexDefaultButton(NSButton b) {
        this.uploadSkipRegexDefaultButton = b;
        this.uploadSkipRegexDefaultButton.setTarget(this.id());
        this.uploadSkipRegexDefaultButton.setAction(Foundation.selector("uploadSkipRegexDefaultButtonClicked:"));
    }

    public void uploadSkipRegexDefaultButtonClicked(NSButton sender) {
        String regex = Preferences.instance().getProperty("queue.upload.skip.regex.default");
        this.uploadSkipRegexField.setString(regex);
        Preferences.instance().setProperty("queue.upload.skip.regex", regex);
    }

    public void setUploadSkipRegexField(NSTextView b) {
        this.uploadSkipRegexField = b;
        this.uploadSkipRegexField.setFont(NSFont.userFixedPitchFontOfSize(9.0));
        this.uploadSkipRegexField.setString(Preferences.instance().getProperty("queue.upload.skip.regex"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("uploadSkipRegexFieldDidChange:"), "NSTextDidChangeNotification", this.uploadSkipRegexField);
    }

    public void uploadSkipRegexFieldDidChange(NSNotification sender) {
        String value = this.uploadSkipRegexField.string().trim();
        if ("".equals(value)) {
            Preferences.instance().setProperty("queue.upload.skip.enable", false);
            Preferences.instance().setProperty("queue.upload.skip.regex", value);
            this.uploadSkipButton.setState(0);
        }
        try {
            Pattern compiled = Pattern.compile(value);
            Preferences.instance().setProperty("queue.upload.skip.regex", compiled.pattern());
            this.mark(this.uploadSkipRegexField.textStorage(), null);
        }
        catch (PatternSyntaxException e) {
            this.mark(this.uploadSkipRegexField.textStorage(), e);
        }
    }

    private void mark(NSMutableAttributedString text, PatternSyntaxException e) {
        if (null == e) {
            text.removeAttributeInRange("NSColor", NSRange.NSMakeRange(new NSUInteger(0L), text.length()));
            return;
        }
        int index = e.getIndex();
        NSRange range = null;
        if (-1 == index) {
            range = NSRange.NSMakeRange(new NSUInteger(0L), text.length());
        }
        if (index < text.length().intValue()) {
            range = NSRange.NSMakeRange(new NSUInteger(index), new NSUInteger(1L));
        }
        text.addAttributesInRange(RED_FONT, range);
    }

    public void setLoginField(NSTextField f) {
        this.loginField = f;
        this.loginField.setStringValue(Preferences.instance().getProperty("connection.login.name"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("loginFieldDidChange:"), "NSControlTextDidChangeNotification", this.loginField);
    }

    public void loginFieldDidChange(NSNotification sender) {
        Preferences.instance().setProperty("connection.login.name", this.loginField.stringValue());
    }

    public void setKeychainCheckbox(NSButton b) {
        this.keychainCheckbox = b;
        this.keychainCheckbox.setTarget(this.id());
        this.keychainCheckbox.setAction(Foundation.selector("keychainCheckboxClicked:"));
        this.keychainCheckbox.setState(Preferences.instance().getBoolean("connection.login.useKeychain") ? 1 : 0);
    }

    public void keychainCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("connection.login.useKeychain", enabled);
    }

    public void setDoubleClickCheckbox(NSButton b) {
        this.doubleClickCheckbox = b;
        this.doubleClickCheckbox.setTarget(this.id());
        this.doubleClickCheckbox.setAction(Foundation.selector("doubleClickCheckboxClicked:"));
        this.doubleClickCheckbox.setState(Preferences.instance().getBoolean("browser.doubleclick.edit") ? 1 : 0);
    }

    public void doubleClickCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.doubleclick.edit", enabled);
    }

    public void setReturnKeyCheckbox(NSButton b) {
        this.returnKeyCheckbox = b;
        this.returnKeyCheckbox.setTarget(this.id());
        this.returnKeyCheckbox.setAction(Foundation.selector("returnKeyCheckboxClicked:"));
        this.returnKeyCheckbox.setState(Preferences.instance().getBoolean("browser.enterkey.rename") ? 1 : 0);
    }

    public void returnKeyCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.enterkey.rename", enabled);
    }

    public void setShowHiddenCheckbox(NSButton b) {
        this.showHiddenCheckbox = b;
        this.showHiddenCheckbox.setTarget(this.id());
        this.showHiddenCheckbox.setAction(Foundation.selector("showHiddenCheckboxClicked:"));
        this.showHiddenCheckbox.setState(Preferences.instance().getBoolean("browser.showHidden") ? 1 : 0);
    }

    public void showHiddenCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.showHidden", enabled);
    }

    public void setBringQueueToFrontCheckbox(NSButton b) {
        this.bringQueueToFrontCheckbox = b;
        this.bringQueueToFrontCheckbox.setTarget(this.id());
        this.bringQueueToFrontCheckbox.setAction(Foundation.selector("bringQueueToFrontCheckboxClicked:"));
        this.bringQueueToFrontCheckbox.setState(Preferences.instance().getBoolean("queue.orderFrontOnStart") ? 1 : 0);
    }

    public void bringQueueToFrontCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.orderFrontOnStart", enabled);
    }

    public void setBringQueueToBackCheckbox(NSButton b) {
        this.bringQueueToBackCheckbox = b;
        this.bringQueueToBackCheckbox.setTarget(this.id());
        this.bringQueueToBackCheckbox.setAction(Foundation.selector("bringQueueToBackCheckboxClicked:"));
        this.bringQueueToBackCheckbox.setState(Preferences.instance().getBoolean("queue.orderBackOnStop") ? 1 : 0);
    }

    public void bringQueueToBackCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.orderBackOnStop", enabled);
    }

    public void setRemoveFromQueueCheckbox(NSButton b) {
        this.removeFromQueueCheckbox = b;
        this.removeFromQueueCheckbox.setTarget(this.id());
        this.removeFromQueueCheckbox.setAction(Foundation.selector("removeFromQueueCheckboxClicked:"));
        this.removeFromQueueCheckbox.setState(Preferences.instance().getBoolean("queue.removeItemWhenComplete") ? 1 : 0);
    }

    public void removeFromQueueCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.removeItemWhenComplete", enabled);
    }

    public void setOpenAfterDownloadCheckbox(NSButton b) {
        this.openAfterDownloadCheckbox = b;
        this.openAfterDownloadCheckbox.setTarget(this.id());
        this.openAfterDownloadCheckbox.setAction(Foundation.selector("openAfterDownloadCheckboxClicked:"));
        this.openAfterDownloadCheckbox.setState(Preferences.instance().getBoolean("queue.postProcessItemWhenComplete") ? 1 : 0);
    }

    public void openAfterDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.postProcessItemWhenComplete", enabled);
    }

    private void duplicateComboboxClicked(String selected, String property) {
        if (selected.equals(TransferAction.ACTION_CALLBACK.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_CALLBACK.toString());
        } else if (selected.equals(TransferAction.ACTION_OVERWRITE.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_OVERWRITE.toString());
        } else if (selected.equals(TransferAction.ACTION_RESUME.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_RESUME.toString());
        } else if (selected.equals(TransferAction.ACTION_RENAME.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_RENAME.toString());
        } else if (selected.equals(TransferAction.ACTION_RENAME_EXISTING.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_RENAME_EXISTING.toString());
        } else if (selected.equals(TransferAction.ACTION_SKIP.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_SKIP.toString());
        }
    }

    public void setDuplicateDownloadCombobox(NSPopUpButton b) {
        this.duplicateDownloadCombobox = b;
        this.duplicateDownloadCombobox.setTarget(this.id());
        this.duplicateDownloadCombobox.setAction(Foundation.selector("duplicateDownloadComboboxClicked:"));
        this.duplicateDownloadCombobox.removeAllItems();
        this.duplicateDownloadCombobox.addItemsWithTitles(NSArray.arrayWithObjects(TransferAction.ACTION_CALLBACK.getLocalizableString(), TransferAction.ACTION_OVERWRITE.getLocalizableString(), TransferAction.ACTION_RESUME.getLocalizableString(), TransferAction.ACTION_RENAME.getLocalizableString(), TransferAction.ACTION_RENAME_EXISTING.getLocalizableString(), TransferAction.ACTION_SKIP.getLocalizableString()));
        if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_CALLBACK.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_CALLBACK.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_OVERWRITE.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_RESUME.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_RESUME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_RENAME.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_RENAME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_RENAME_EXISTING.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_RENAME_EXISTING.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_SKIP.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_SKIP.getLocalizableString());
        }
    }

    public void duplicateDownloadComboboxClicked(NSPopUpButton sender) {
        this.duplicateComboboxClicked(sender.selectedItem().title(), "queue.download.fileExists");
        this.duplicateDownloadOverwriteButtonClicked(this.duplicateDownloadOverwriteButton);
    }

    public void setDuplicateDownloadOverwriteButton(NSButton b) {
        this.duplicateDownloadOverwriteButton = b;
        this.duplicateDownloadOverwriteButton.setTarget(this.id());
        this.duplicateDownloadOverwriteButton.setAction(Foundation.selector("duplicateDownloadOverwriteButtonClicked:"));
        this.duplicateDownloadOverwriteButton.setState(Preferences.instance().getProperty("queue.download.reload.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString()) ? 1 : 0);
    }

    public void duplicateDownloadOverwriteButtonClicked(NSButton sender) {
        boolean enabled;
        boolean bl = enabled = sender.state() == 1;
        if (enabled) {
            Preferences.instance().setProperty("queue.download.reload.fileExists", TransferAction.ACTION_OVERWRITE.toString());
        } else {
            Preferences.instance().setProperty("queue.download.reload.fileExists", Preferences.instance().getProperty("queue.download.fileExists"));
        }
    }

    public void setDuplicateUploadCombobox(NSPopUpButton b) {
        this.duplicateUploadCombobox = b;
        this.duplicateUploadCombobox.setTarget(this.id());
        this.duplicateUploadCombobox.setAction(Foundation.selector("duplicateUploadComboboxClicked:"));
        this.duplicateUploadCombobox.removeAllItems();
        this.duplicateUploadCombobox.addItemsWithTitles(NSArray.arrayWithObjects(TransferAction.ACTION_CALLBACK.getLocalizableString(), TransferAction.ACTION_OVERWRITE.getLocalizableString(), TransferAction.ACTION_RESUME.getLocalizableString(), TransferAction.ACTION_RENAME.getLocalizableString(), TransferAction.ACTION_RENAME_EXISTING.getLocalizableString(), TransferAction.ACTION_SKIP.getLocalizableString()));
        if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_CALLBACK.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_CALLBACK.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_OVERWRITE.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_RESUME.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_RESUME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_RENAME.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_RENAME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_RENAME_EXISTING.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_RENAME_EXISTING.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_SKIP.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_SKIP.getLocalizableString());
        }
    }

    public void duplicateUploadComboboxClicked(NSPopUpButton sender) {
        this.duplicateComboboxClicked(sender.selectedItem().title(), "queue.upload.fileExists");
        this.duplicateUploadOverwriteButtonClicked(this.duplicateUploadOverwriteButton);
    }

    public void setDuplicateUploadOverwriteButton(NSButton b) {
        this.duplicateUploadOverwriteButton = b;
        this.duplicateUploadOverwriteButton.setTarget(this.id());
        this.duplicateUploadOverwriteButton.setAction(Foundation.selector("duplicateUploadOverwriteButtonClicked:"));
        this.duplicateUploadOverwriteButton.setState(Preferences.instance().getProperty("queue.upload.reload.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString()) ? 1 : 0);
    }

    public void duplicateUploadOverwriteButtonClicked(NSButton sender) {
        boolean enabled;
        boolean bl = enabled = sender.state() == 1;
        if (enabled) {
            Preferences.instance().setProperty("queue.upload.reload.fileExists", TransferAction.ACTION_OVERWRITE.toString());
        } else {
            Preferences.instance().setProperty("queue.upload.reload.fileExists", Preferences.instance().getProperty("queue.upload.fileExists"));
        }
    }

    public void setUploadTemporaryFilenameButton(NSButton b) {
        this.uploadTemporaryFilenameButton = b;
        this.uploadTemporaryFilenameButton.setTarget(this.id());
        this.uploadTemporaryFilenameButton.setAction(Foundation.selector("uploadTemporaryFilenameButtonClicked:"));
        this.uploadTemporaryFilenameButton.setState(Preferences.instance().getBoolean("queue.upload.file.temporary") ? 1 : 0);
    }

    public void uploadTemporaryFilenameButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.file.temporary", enabled);
    }

    public void setProtocolCombobox(NSPopUpButton b) {
        this.protocolCombobox = b;
        this.protocolCombobox.setTarget(this.id());
        this.protocolCombobox.setAction(Foundation.selector("protocolComboboxClicked:"));
        this.protocolCombobox.removeAllItems();
        for (Protocol protocol : ProtocolFactory.getKnownProtocols()) {
            this.protocolCombobox.addItemWithTitle(protocol.getDescription());
        }
        for (Protocol protocol : ProtocolFactory.getKnownProtocols()) {
            NSMenuItem item = this.protocolCombobox.itemWithTitle(protocol.getDescription());
            item.setRepresentedObject(protocol.getIdentifier());
            item.setImage(IconCache.iconNamed(protocol.icon(), 16));
        }
        Protocol defaultProtocol = ProtocolFactory.forName((String)Preferences.instance().getProperty("connection.protocol.default"));
        this.protocolCombobox.selectItemWithTitle(defaultProtocol.getDescription());
    }

    public void protocolComboboxClicked(NSPopUpButton sender) {
        Protocol selected = ProtocolFactory.forName((String)sender.selectedItem().representedObject());
        Preferences.instance().setProperty("connection.protocol.default", selected.getIdentifier());
        Preferences.instance().setProperty("connection.port.default", selected.getDefaultPort());
    }

    public void setConfirmDisconnectCheckbox(NSButton b) {
        this.confirmDisconnectCheckbox = b;
        this.confirmDisconnectCheckbox.setTarget(this.id());
        this.confirmDisconnectCheckbox.setAction(Foundation.selector("confirmDisconnectCheckboxClicked:"));
        this.confirmDisconnectCheckbox.setState(Preferences.instance().getBoolean("browser.confirmDisconnect") ? 1 : 0);
    }

    public void confirmDisconnectCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.confirmDisconnect", enabled);
    }

    public void setSshTransfersCombobox(NSPopUpButton b) {
        this.sshTransfersCombobox = b;
        this.sshTransfersCombobox.setTarget(this.id());
        this.sshTransfersCombobox.setAction(Foundation.selector("sshTransfersComboboxClicked:"));
        this.sshTransfersCombobox.removeAllItems();
        this.sshTransfersCombobox.addItemsWithTitles(NSArray.arrayWithObjects(Protocol.SFTP.getDescription(), Protocol.SCP.getDescription()));
        this.sshTransfersCombobox.itemWithTitle(Protocol.SFTP.getDescription()).setRepresentedObject(Protocol.SFTP.getIdentifier());
        this.sshTransfersCombobox.itemWithTitle(Protocol.SCP.getDescription()).setRepresentedObject(Protocol.SCP.getIdentifier());
        if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.toString())) {
            this.sshTransfersCombobox.selectItemWithTitle(Protocol.SFTP.getDescription());
        } else if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SCP.toString())) {
            this.sshTransfersCombobox.selectItemWithTitle(Protocol.SCP.getDescription());
        }
    }

    public void sshTransfersComboboxClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("ssh.transfer", sender.selectedItem().representedObject());
    }

    private void configureDefaultProtocolHandlerCombobox(NSPopUpButton defaultProtocolHandlerCombobox, Protocol protocol) {
        String[] bundleIdentifiers;
        String defaultHandler = URLSchemeHandlerConfiguration.instance().getDefaultHandlerForURLScheme(protocol.getScheme());
        if (null == defaultHandler) {
            defaultProtocolHandlerCombobox.addItemWithTitle(Locale.localizedString((String)"Unknown"));
            defaultProtocolHandlerCombobox.setEnabled(false);
            return;
        }
        log.debug((Object)("Default Protocol Handler for " + protocol + ":" + defaultHandler));
        for (String bundleIdentifier : bundleIdentifiers = URLSchemeHandlerConfiguration.instance().getAllHandlersForURLScheme(protocol.getScheme())) {
            String app = EditorFactory.getApplicationName(bundleIdentifier);
            if (StringUtils.isEmpty((String)app)) continue;
            defaultProtocolHandlerCombobox.addItemWithTitle(app);
            NSMenuItem item = defaultProtocolHandlerCombobox.lastItem();
            item.setImage(IconCache.instance().iconForApplication(bundleIdentifier, 16));
            item.setRepresentedObject(bundleIdentifier);
            if (!bundleIdentifier.equals(defaultHandler)) continue;
            defaultProtocolHandlerCombobox.selectItem(item);
        }
    }

    public void setDefaultFTPHandlerCombobox(NSPopUpButton b) {
        this.defaultFTPHandlerCombobox = b;
        this.defaultFTPHandlerCombobox.setTarget(this.id());
        this.defaultFTPHandlerCombobox.setAction(Foundation.selector("defaultFTPHandlerComboboxClicked:"));
        this.defaultFTPHandlerCombobox.removeAllItems();
        this.configureDefaultProtocolHandlerCombobox(this.defaultFTPHandlerCombobox, Protocol.FTP);
    }

    public void defaultFTPHandlerComboboxClicked(NSPopUpButton sender) {
        String bundle = sender.selectedItem().representedObject();
        URLSchemeHandlerConfiguration.instance().setDefaultHandlerForURLScheme(new String[]{Protocol.FTP.getScheme(), Protocol.FTP_TLS.getScheme()}, bundle);
    }

    public void setDefaultSFTPHandlerCombobox(NSPopUpButton b) {
        this.defaultSFTPHandlerCombobox = b;
        this.defaultSFTPHandlerCombobox.setTarget(this.id());
        this.defaultSFTPHandlerCombobox.setAction(Foundation.selector("defaultSFTPHandlerComboboxClicked:"));
        this.defaultSFTPHandlerCombobox.removeAllItems();
        this.configureDefaultProtocolHandlerCombobox(this.defaultSFTPHandlerCombobox, Protocol.SFTP);
    }

    public void defaultSFTPHandlerComboboxClicked(NSPopUpButton sender) {
        String bundle = sender.selectedItem().representedObject();
        URLSchemeHandlerConfiguration.instance().setDefaultHandlerForURLScheme(Protocol.SFTP.getScheme(), bundle);
    }

    public void setDefaultDownloadThrottleCombobox(NSPopUpButton b) {
        this.defaultDownloadThrottleCombobox = b;
        this.defaultDownloadThrottleCombobox.setTarget(this.id());
        this.defaultDownloadThrottleCombobox.setAction(Foundation.selector("defaultDownloadThrottleComboboxClicked:"));
        int bandwidth = (int)Preferences.instance().getDouble("queue.download.bandwidth.bytes");
        StringTokenizer options = new StringTokenizer(Preferences.instance().getProperty("queue.bandwidth.options"), ",");
        while (options.hasMoreTokens()) {
            String bytes = options.nextToken();
            this.defaultDownloadThrottleCombobox.addItemWithTitle(Status.getSizeAsString((double)Integer.parseInt(bytes)) + "/s");
            this.defaultDownloadThrottleCombobox.lastItem().setRepresentedObject(bytes);
        }
        if (-1 == bandwidth) {
            this.defaultDownloadThrottleCombobox.selectItemWithTag(new NSInteger(-1L));
        } else {
            this.defaultDownloadThrottleCombobox.selectItemAtIndex(this.defaultDownloadThrottleCombobox.menu().indexOfItemWithRepresentedObject(String.valueOf(bandwidth)));
        }
    }

    public void defaultDownloadThrottleComboboxClicked(NSPopUpButton sender) {
        String bytes = sender.selectedItem().representedObject();
        if (null == bytes) {
            Preferences.instance().setProperty("queue.download.bandwidth.bytes", -1);
        } else {
            Preferences.instance().setProperty("queue.download.bandwidth.bytes", Integer.parseInt(bytes));
        }
    }

    public void setDefaultUploadThrottleCombobox(NSPopUpButton b) {
        this.defaultUploadThrottleCombobox = b;
        this.defaultUploadThrottleCombobox.setTarget(this.id());
        this.defaultUploadThrottleCombobox.setAction(Foundation.selector("defaultUploadThrottleComboboxClicked:"));
        int bandwidth = (int)Preferences.instance().getDouble("queue.upload.bandwidth.bytes");
        StringTokenizer options = new StringTokenizer(Preferences.instance().getProperty("queue.bandwidth.options"), ",");
        while (options.hasMoreTokens()) {
            String bytes = options.nextToken();
            this.defaultUploadThrottleCombobox.addItemWithTitle(Status.getSizeAsString((double)Integer.parseInt(bytes)) + "/s");
            this.defaultUploadThrottleCombobox.lastItem().setRepresentedObject(bytes);
        }
        if (-1 == bandwidth) {
            this.defaultUploadThrottleCombobox.selectItemWithTag(new NSInteger(-1L));
        } else {
            this.defaultUploadThrottleCombobox.selectItemAtIndex(this.defaultUploadThrottleCombobox.menu().indexOfItemWithRepresentedObject(String.valueOf(bandwidth)));
        }
    }

    public void defaultUploadThrottleComboboxClicked(NSPopUpButton sender) {
        String bytes = sender.selectedItem().representedObject();
        if (null == bytes) {
            Preferences.instance().setProperty("queue.upload.bandwidth.bytes", -1);
        } else {
            Preferences.instance().setProperty("queue.upload.bandwidth.bytes", Integer.parseInt(bytes));
        }
    }

    public void setUpdateCheckbox(NSButton b) {
        this.updateCheckbox = b;
        this.updateCheckbox.setTarget(this.id());
        this.updateCheckbox.setAction(Foundation.selector("updateCheckboxClicked:"));
        this.updateCheckbox.setState(Preferences.instance().getBoolean("update.check") ? 1 : 0);
    }

    public void updateCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("update.check", enabled);
        if (enabled) {
            Preferences.instance().setProperty("SUScheduledCheckInterval", Preferences.instance().getProperty("update.check.interval"));
        } else {
            Preferences.instance().deleteProperty("SUScheduledCheckInterval");
        }
    }

    public void setUpdateFeedPopup(NSPopUpButton b) {
        this.updateFeedPopup = b;
        this.updateFeedPopup.removeAllItems();
        this.updateFeedPopup.setAction(Foundation.selector("updateFeedPopupClicked:"));
        this.updateFeedPopup.addItemWithTitle(Locale.localizedString((String)"Release"));
        this.updateFeedPopup.lastItem().setRepresentedObject(Preferences.instance().getProperty("update.feed.release"));
        this.updateFeedPopup.addItemWithTitle(Locale.localizedString((String)"Beta"));
        this.updateFeedPopup.lastItem().setRepresentedObject(Preferences.instance().getProperty("update.feed.beta"));
        this.updateFeedPopup.addItemWithTitle(Locale.localizedString((String)"Snapshot Builds"));
        this.updateFeedPopup.lastItem().setRepresentedObject(Preferences.instance().getProperty("update.feed.nightly"));
        String feed = Preferences.instance().getProperty("SUFeedURL");
        NSInteger selected = this.updateFeedPopup.menu().indexOfItemWithRepresentedObject(feed);
        if (-1 == selected.intValue()) {
            log.warn((Object)("Invalid feed setting:" + feed));
            this.updateFeedPopup.selectItemAtIndex(this.updateFeedPopup.menu().indexOfItemWithRepresentedObject(Preferences.instance().getProperty("update.feed.release")));
        } else {
            this.updateFeedPopup.selectItemAtIndex(selected);
        }
    }

    public void updateFeedPopupClicked(NSPopUpButton sender) {
        String selected = sender.selectedItem().representedObject();
        if (null == selected || Preferences.instance().getDefault("SUFeedURL").equals(selected)) {
            Preferences.instance().deleteProperty("SUFeedURL");
        } else {
            Preferences.instance().setProperty("SUFeedURL", selected);
        }
    }

    public void setDefaultBucketLocation(NSPopUpButton b) {
        this.defaultBucketLocation = b;
        this.defaultBucketLocation.setAutoenablesItems(false);
        this.defaultBucketLocation.removeAllItems();
        for (String location : S3Session.getAvailableLocations()) {
            this.defaultBucketLocation.addItemWithTitle(Locale.localizedString((String)location, (String)"S3"));
            this.defaultBucketLocation.lastItem().setRepresentedObject(location);
        }
        this.defaultBucketLocation.setTarget(this.id());
        this.defaultBucketLocation.setAction(Foundation.selector("defaultBucketLocationClicked:"));
        this.defaultBucketLocation.selectItemWithTitle(Locale.localizedString((String)Preferences.instance().getProperty("s3.location"), (String)"S3"));
    }

    public void defaultBucketLocationClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("s3.location", sender.selectedItem().representedObject());
    }

    public void setDefaultStorageClassPopup(NSPopUpButton b) {
        this.defaultStorageClassPopup = b;
        this.defaultStorageClassPopup.setAutoenablesItems(false);
        this.defaultStorageClassPopup.removeAllItems();
        this.defaultStorageClassPopup.addItemWithTitle(Locale.localizedString((String)"STANDARD", (String)"S3"));
        this.defaultStorageClassPopup.lastItem().setRepresentedObject("STANDARD");
        this.defaultStorageClassPopup.addItemWithTitle(Locale.localizedString((String)"REDUCED_REDUNDANCY", (String)"S3"));
        this.defaultStorageClassPopup.lastItem().setRepresentedObject("REDUCED_REDUNDANCY");
        this.defaultStorageClassPopup.setTarget(this.id());
        this.defaultStorageClassPopup.setAction(Foundation.selector("setDefaultStorageClassPopupClicked:"));
        this.defaultStorageClassPopup.selectItemWithTitle(Locale.localizedString((String)Preferences.instance().getProperty("s3.storage.class"), (String)"S3"));
    }

    public void setDefaultStorageClassPopupClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("s3.storage.class", sender.selectedItem().representedObject());
    }

    public void setDocumentExportFormatPopup(NSPopUpButton b) {
        this.documentExportFormatPopup = b;
        this.documentExportFormatPopup.setAutoenablesItems(false);
        this.documentExportFormatPopup.removeAllItems();
        StringTokenizer formats = new StringTokenizer(Preferences.instance().getProperty("google.docs.export.document.formats"), ",");
        int i = 0;
        while (formats.hasMoreTokens()) {
            String format = formats.nextToken();
            String title = FinderLocal.kind(format) + " (." + format + ")";
            this.documentExportFormatPopup.addItemWithTitle(title);
            this.documentExportFormatPopup.lastItem().setRepresentedObject(format);
            if (format.equals(Preferences.instance().getProperty("google.docs.export.document"))) {
                this.documentExportFormatPopup.selectItemWithTitle(title);
            }
            ++i;
        }
        this.documentExportFormatPopup.setTarget(this.id());
        this.documentExportFormatPopup.setAction(Foundation.selector("documentExportFormatPopupClicked:"));
    }

    public void documentExportFormatPopupClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("google.docs.export.document", sender.selectedItem().representedObject());
    }

    public void setSpreadsheetExportFormatPopup(NSPopUpButton b) {
        this.spreadsheetExportFormatPopup = b;
        this.spreadsheetExportFormatPopup.setAutoenablesItems(false);
        this.spreadsheetExportFormatPopup.removeAllItems();
        StringTokenizer formats = new StringTokenizer(Preferences.instance().getProperty("google.docs.export.spreadsheet.formats"), ",");
        int i = 0;
        while (formats.hasMoreTokens()) {
            String format = formats.nextToken();
            String title = FinderLocal.kind(format) + " (." + format + ")";
            this.spreadsheetExportFormatPopup.addItemWithTitle(title);
            this.spreadsheetExportFormatPopup.lastItem().setRepresentedObject(format);
            if (format.equals(Preferences.instance().getProperty("google.docs.export.spreadsheet"))) {
                this.spreadsheetExportFormatPopup.selectItemWithTitle(title);
            }
            ++i;
        }
        this.spreadsheetExportFormatPopup.setTarget(this.id());
        this.spreadsheetExportFormatPopup.setAction(Foundation.selector("spreadsheetExportFormatPopupClicked:"));
    }

    public void spreadsheetExportFormatPopupClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("google.docs.export.spreadsheet", sender.selectedItem().representedObject());
    }

    public void setPresentationExportFormatPopup(NSPopUpButton b) {
        this.presentationExportFormatPopup = b;
        this.presentationExportFormatPopup.setAutoenablesItems(false);
        this.presentationExportFormatPopup.removeAllItems();
        StringTokenizer formats = new StringTokenizer(Preferences.instance().getProperty("google.docs.export.presentation.formats"), ",");
        int i = 0;
        while (formats.hasMoreTokens()) {
            String format = formats.nextToken();
            String title = FinderLocal.kind(format) + " (." + format + ")";
            this.presentationExportFormatPopup.addItemWithTitle(title);
            this.presentationExportFormatPopup.lastItem().setRepresentedObject(format);
            if (format.equals(Preferences.instance().getProperty("google.docs.export.presentation"))) {
                this.presentationExportFormatPopup.selectItemWithTitle(title);
            }
            ++i;
        }
        this.presentationExportFormatPopup.setTarget(this.id());
        this.presentationExportFormatPopup.setAction(Foundation.selector("presentationExportFormatPopupClicked:"));
    }

    public void presentationExportFormatPopupClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("google.docs.export.presentation", sender.selectedItem().representedObject());
    }

    public void setConvertUploadsCheckbox(NSButton b) {
        this.convertUploadsCheckbox = b;
        this.convertUploadsCheckbox.setTarget(this.id());
        this.convertUploadsCheckbox.setAction(Foundation.selector("convertUploadsCheckboxClicked:"));
        this.convertUploadsCheckbox.setState(Preferences.instance().getBoolean("google.docs.upload.convert") ? 1 : 0);
    }

    public void convertUploadsCheckboxClicked(NSButton sender) {
        Preferences.instance().setProperty("google.docs.upload.convert", sender.state() == 1);
    }

    public void setOcrUploadsCheckbox(NSButton b) {
        this.ocrUploadsCheckbox = b;
        this.ocrUploadsCheckbox.setTarget(this.id());
        this.ocrUploadsCheckbox.setAction(Foundation.selector("ocrUploadsCheckboxClicked:"));
        this.ocrUploadsCheckbox.setState(Preferences.instance().getBoolean("google.docs.upload.ocr") ? 1 : 0);
    }

    public void ocrUploadsCheckboxClicked(NSButton sender) {
        Preferences.instance().setProperty("google.docs.upload.ocr", sender.state() == 1);
    }

    public void setLanguagePopup(NSPopUpButton b) {
        this.languagePopup = b;
        this.languagePopup.removeAllItems();
        this.languagePopup.setTarget(this.id());
        this.languagePopup.setAction(Foundation.selector("languagePopupClicked:"));
        this.languagePopup.addItemWithTitle(Locale.localizedString((String)"Default"));
        this.languagePopup.menu().addItem(NSMenuItem.separatorItem());
        String custom = null;
        if (Preferences.instance().systemLocales().size() > 1) {
            this.languagePopup.selectItemWithTitle(Locale.localizedString((String)"Default"));
        } else {
            custom = Preferences.instance().locale();
        }
        for (String identifier : Preferences.instance().applicationLocales()) {
            this.languagePopup.addItemWithTitle(Preferences.instance().getDisplayName(identifier));
            this.languagePopup.lastItem().setRepresentedObject(identifier);
            if (!identifier.equals(custom)) continue;
            this.languagePopup.selectItem(this.languagePopup.lastItem());
        }
    }

    public void languagePopupClicked(NSPopUpButton sender) {
        if (null == sender.selectedItem().representedObject()) {
            Preferences.instance().deleteProperty("AppleLanguages");
        } else {
            Preferences.instance().setProperty("AppleLanguages", Collections.singletonList(sender.selectedItem().representedObject()));
        }
    }

    public void setUseProxiesButton(NSPopUpButton b) {
        this.useProxiesButton = b;
        this.useProxiesButton.setTarget(this.id());
        this.useProxiesButton.setAction(Foundation.selector("useProxiesButtonClicked:"));
        this.useProxiesButton.setState(Preferences.instance().getBoolean("connection.proxy.enable") ? 1 : 0);
    }

    public void useProxiesButtonClicked(NSButton sender) {
        Preferences.instance().setProperty("connection.proxy.enable", sender.state() == 1);
    }

    public void setConfigureProxiesButton(NSPopUpButton b) {
        this.configureProxiesButton = b;
        this.configureProxiesButton.setTarget(this.id());
        this.configureProxiesButton.setAction(Foundation.selector("configureProxiesButtonClicked:"));
    }

    public void configureProxiesButtonClicked(NSButton sender) {
        String script = "tell application \"System Preferences\"\nactivate\nreveal anchor \"Proxies\" of pane \"com.apple.preference.network\"\nend tell";
        NSAppleScript open = NSAppleScript.createWithSource("tell application \"System Preferences\"\nactivate\nreveal anchor \"Proxies\" of pane \"com.apple.preference.network\"\nend tell");
        open.executeAndReturnError(null);
    }

    private static class EditorOpenPanelDelegate
    extends ProxyController {
        private EditorOpenPanelDelegate() {
        }

        public boolean panel_shouldShowFilename(ID panel, String path) {
            Local f = LocalFactory.createLocal((String)path);
            if (f.attributes().isDirectory()) {
                return true;
            }
            String extension = f.getExtension();
            if (StringUtils.isEmpty((String)extension)) {
                return false;
            }
            return extension.equals("app");
        }
    }
}

