/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Speedometer;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.AbstractController;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.TransferMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

public class ProgressController
extends BundleController {
    private static Logger log = Logger.getLogger(ProgressController.class);
    private Transfer transfer;
    private Speedometer meter;
    private String messageText;
    private ProgressListener pl;
    private TransferListener tl;
    private static final NSDictionary NORMAL_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), TableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObjects("NSFont", "NSParagraphStyle"));
    private static final NSDictionary HIGHLIGHTED_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), NSColor.whiteColor(), TableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObjects("NSFont", "NSColor", "NSParagraphStyle"));
    private static final NSDictionary DARK_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), NSColor.darkGrayColor(), TableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObjects("NSFont", "NSColor", "NSParagraphStyle"));
    private boolean highlighted;
    private NSPopUpButton filesPopup;
    private AbstractMenuDelegate filesPopupMenuDelegate;
    private NSTextField progressField;
    private NSTextField statusField;
    private NSTextField messageField;
    private NSProgressIndicator progressBar;
    private NSImageView statusIconView;
    private static final NSImage RED_ICON = IconCache.iconNamed("statusRed.tiff");
    private static final NSImage GREEN_ICON = IconCache.iconNamed("statusGreen.tiff");
    private static final NSImage YELLOW_ICON = IconCache.iconNamed("statusYellow.tiff");
    private NSImageView iconImageView;
    private NSView progressView;

    public ProgressController(Transfer transfer) {
        this.transfer = transfer;
        this.meter = new Speedometer(transfer);
        this.init();
    }

    protected void invalidate() {
        this.transfer.getSession().removeProgressListener(this.pl);
        this.transfer.removeListener(this.tl);
        this.filesPopup.menu().setDelegate(null);
        super.invalidate();
    }

    protected String getBundleName() {
        return "Progress.nib";
    }

    private void init() {
        this.loadBundle();
        this.tl = new TransferAdapter(){
            private ScheduledFuture progressTimer;
            static final long delay = 0L;
            static final long period = 200L;

            public void transferWillStart() {
                ProgressController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        ProgressController.this.transfer.getSession().addProgressListener(ProgressController.this.pl = new ProgressListener(){

                            public void message(String message) {
                                ProgressController.this.messageText = message;
                                ProgressController.this.invoke((MainAction)new DefaultMainAction(){

                                    public void run() {
                                        ProgressController.this.setMessageText();
                                    }
                                });
                            }
                        });
                        ProgressController.this.progressBar.setHidden(false);
                        ProgressController.this.progressBar.setIndeterminate(true);
                        ProgressController.this.progressBar.startAnimation(null);
                        ProgressController.this.statusIconView.setImage(YELLOW_ICON);
                        ProgressController.this.setProgressText();
                        ProgressController.this.setStatusText();
                    }
                });
            }

            public void transferDidEnd() {
                ProgressController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        ProgressController.this.transfer.getSession().removeProgressListener(ProgressController.this.pl);
                        ProgressController.this.progressBar.stopAnimation(null);
                        ProgressController.this.progressBar.setIndeterminate(true);
                        ProgressController.this.progressBar.setHidden(true);
                        ProgressController.this.messageText = null;
                        ProgressController.this.setMessageText();
                        ProgressController.this.setProgressText();
                        ProgressController.this.setStatusText();
                        ProgressController.this.statusIconView.setImage(ProgressController.this.transfer.isComplete() ? GREEN_ICON : RED_ICON);
                        ProgressController.this.filesPopup.itemAtIndex(new NSInteger(0L)).setEnabled(ProgressController.this.transfer.getRoot().getLocal().exists());
                    }
                });
            }

            public void willTransferPath(Path path) {
                ProgressController.this.meter.reset();
                this.progressTimer = AbstractController.getTimerPool().scheduleAtFixedRate(new Runnable(){

                    public void run() {
                        ProgressController.this.invoke((MainAction)new DefaultMainAction(){

                            public void run() {
                                ProgressController.this.setProgressText();
                                double transferred = ProgressController.this.transfer.getTransferred();
                                double size = ProgressController.this.transfer.getSize();
                                if (transferred > 0.0 && size > 0.0) {
                                    ProgressController.this.progressBar.setIndeterminate(false);
                                    ProgressController.this.progressBar.setMaxValue(size);
                                    ProgressController.this.progressBar.setDoubleValue(transferred);
                                }
                            }
                        });
                    }
                }, 0L, 200L, TimeUnit.MILLISECONDS);
            }

            public void didTransferPath(Path path) {
                boolean canceled = false;
                while (!canceled) {
                    canceled = this.progressTimer.cancel(false);
                }
                ProgressController.this.meter.reset();
            }

            public void bandwidthChanged(BandwidthThrottle bandwidth) {
                ProgressController.this.meter.reset();
            }
        };
        this.transfer.addListener(this.tl);
    }

    public void awakeFromNib() {
        this.setProgressText();
        this.setMessageText();
        this.setStatusText();
        super.awakeFromNib();
    }

    private void setMessageText() {
        Date timestamp;
        StringBuilder b = new StringBuilder();
        if (null == this.messageText && null != (timestamp = this.transfer.getTimestamp())) {
            this.messageText = DateFormatterFactory.instance().getLongFormat(timestamp.getTime());
        }
        if (this.messageText != null) {
            b.append(this.messageText);
        }
        this.messageField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(b.toString(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void setProgressText() {
        this.progressField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.meter.getProgress(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void setStatusText() {
        StringBuilder b = new StringBuilder();
        if (!this.transfer.isRunning()) {
            if (this.transfer instanceof DownloadTransfer) {
                b.append(this.transfer.isComplete() ? Locale.localizedString((String)"Download complete", (String)"Growl") : Locale.localizedString((String)"Transfer incomplete", (String)"Status"));
            }
            if (this.transfer instanceof UploadTransfer) {
                b.append(this.transfer.isComplete() ? Locale.localizedString((String)"Upload complete", (String)"Growl") : Locale.localizedString((String)"Transfer incomplete", (String)"Status"));
            }
            if (this.transfer instanceof SyncTransfer) {
                b.append(this.transfer.isComplete() ? Locale.localizedString((String)"Synchronization complete", (String)"Growl") : Locale.localizedString((String)"Transfer incomplete", (String)"Status"));
            }
        }
        this.statusField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(b.toString(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.statusField.setTextColor(highlighted ? NSColor.whiteColor() : NSColor.textColor());
        this.progressField.setTextColor(highlighted ? NSColor.whiteColor() : NSColor.darkGrayColor());
        this.messageField.setTextColor(highlighted ? NSColor.whiteColor() : NSColor.darkGrayColor());
        this.setMenuHighlighted(highlighted);
        this.highlighted = highlighted;
    }

    private void setMenuHighlighted(boolean highlighted) {
        this.filesPopup.itemAtIndex(new NSInteger(0L)).setAttributedTitle(NSAttributedString.attributedStringWithAttributes(this.filesPopup.itemAtIndex(new NSInteger(0L)).title(), highlighted ? HIGHLIGHTED_FONT_ATTRIBUTES : (this.transfer.getRoot().getLocal().exists() ? NORMAL_FONT_ATTRIBUTES : DARK_FONT_ATTRIBUTES)));
    }

    public void setFilesPopup(NSPopUpButton filesPopup) {
        this.filesPopup = filesPopup;
        this.filesPopup.setTarget(this.id());
        this.filesPopup.removeAllItems();
        Path path = this.transfer.getRoot();
        NSMenuItem item = this.filesPopup.menu().addItemWithTitle_action_keyEquivalent(path.getName(), Foundation.selector("reveal:"), "");
        item.setRepresentedObject(path.getAbsolute());
        item.setImage(IconCache.instance().iconForPath(path, 16, false));
        item.setEnabled(path.getLocal().exists());
        this.filesPopupMenuDelegate = new TransferMenuDelegate(this.transfer.getRoots());
        this.filesPopup.menu().setDelegate(this.filesPopupMenuDelegate.id());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("filesPopupWillShow:"), "NSPopUpButtonWillPopUpNotification", this.filesPopup);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("filesPopupWillHide:"), "NSMenuDidEndTrackingNotification", this.filesPopup.menu());
    }

    public void filesPopupWillShow(NSNotification sender) {
        this.setMenuHighlighted(false);
    }

    public void filesPopupWillHide(NSNotification sender) {
        this.setMenuHighlighted(true);
    }

    public void setProgressField(NSTextField progressField) {
        this.progressField = progressField;
        this.progressField.setEditable(false);
        this.progressField.setSelectable(false);
        this.progressField.setTextColor(NSColor.darkGrayColor());
    }

    public void setStatusField(NSTextField statusField) {
        this.statusField = statusField;
        this.statusField.setEditable(false);
        this.statusField.setSelectable(false);
        this.statusField.setTextColor(NSColor.darkGrayColor());
    }

    public void setMessageField(NSTextField messageField) {
        this.messageField = messageField;
        this.messageField.setEditable(false);
        this.messageField.setSelectable(false);
        this.messageField.setTextColor(NSColor.darkGrayColor());
    }

    public void setProgressBar(NSProgressIndicator progressBar) {
        this.progressBar = progressBar;
        this.progressBar.setDisplayedWhenStopped(false);
        this.progressBar.setUsesThreadedAnimation(true);
        this.progressBar.setControlSize(1);
        this.progressBar.setStyle(0);
        this.progressBar.setMinValue(0.0);
    }

    public void setStatusIconView(NSImageView statusIconView) {
        this.statusIconView = statusIconView;
        this.statusIconView.setImage(this.transfer.isComplete() ? GREEN_ICON : RED_ICON);
    }

    public void setIconImageView(NSImageView iconImageView) {
        this.iconImageView = iconImageView;
        if (this.transfer instanceof DownloadTransfer) {
            iconImageView.setImage(IconCache.iconNamed("arrowDown.tiff", 32));
        } else if (this.transfer instanceof UploadTransfer) {
            iconImageView.setImage(IconCache.iconNamed("arrowUp.tiff", 32));
        } else if (this.transfer instanceof SyncTransfer) {
            iconImageView.setImage(IconCache.iconNamed("sync.tiff", 32));
        }
    }

    public void setProgressView(NSView v) {
        this.progressView = v;
    }

    public NSView view() {
        return this.progressView;
    }
}

