/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.ui.cocoa.SyncPromptModel;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class SyncPromptController
extends TransferPromptController {
    private static Logger log = Logger.getLogger(SyncPromptController.class);

    public SyncPromptController(WindowController parent, Transfer transfer) {
        super(parent, transfer);
    }

    public TransferAction prompt() {
        this.browserModel = new SyncPromptModel(this, this.transfer);
        this.action = TransferAction.ACTION_OVERWRITE;
        return super.prompt();
    }

    public void setBrowserView(NSOutlineView view) {
        super.setBrowserView(view);
        NSTableColumn c = this.tableColumnsFactory.create("SYNC");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setEditable(false);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        view.addTableColumn(c);
        c = this.tableColumnsFactory.create("CREATE");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setEditable(false);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        view.addTableColumn(c);
        view.sizeToFit();
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.action = TransferAction.ACTION_OVERWRITE;
        } else if (returncode == -1) {
            this.action = TransferAction.ACTION_CANCEL;
        }
    }

    public void setActionPopup(NSPopUpButton actionPopup) {
        TransferAction[] actions;
        this.actionPopup = actionPopup;
        this.actionPopup.removeAllItems();
        TransferAction defaultAction = ((SyncTransfer)this.transfer).getAction();
        for (TransferAction action : actions = new TransferAction[]{SyncTransfer.ACTION_DOWNLOAD, SyncTransfer.ACTION_UPLOAD, SyncTransfer.ACTION_MIRROR}) {
            this.actionPopup.addItemWithTitle(action.getLocalizableString());
            this.actionPopup.lastItem().setRepresentedObject(action.toString());
            if (!action.equals((Object)defaultAction)) continue;
            this.actionPopup.selectItem(actionPopup.lastItem());
        }
        this.actionPopup.setTarget(this.id());
        this.actionPopup.setAction(Foundation.selector("actionPopupClicked:"));
    }

    public void actionPopupClicked(NSPopUpButton sender) {
        TransferAction selected;
        TransferAction current = ((SyncTransfer)this.transfer).getAction();
        if (current.equals((Object)(selected = TransferAction.forName((String)sender.selectedItem().representedObject())))) {
            return;
        }
        Preferences.instance().setProperty("queue.sync.action.default", selected.toString());
        ((SyncTransfer)this.transfer).setTransferAction(selected);
        this.reloadData();
    }
}

