/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.OutlineDataSource;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNumber;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.model.OutlinePathReference;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransferPromptModel
extends OutlineDataSource {
    protected static Logger log = Logger.getLogger(TransferPromptModel.class);
    protected final Transfer transfer;
    protected final AttributedList<Path> roots = new AttributedList();
    private TransferPromptController controller;
    protected static final String INCLUDE_COLUMN = "INCLUDE";
    protected static final String WARNING_COLUMN = "WARNING";
    protected static final String FILENAME_COLUMN = "FILENAME";
    protected static final String SIZE_COLUMN = "SIZE";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    private final List<Path> isLoadingListingInBackground = new Collection();
    protected AttributeCache<Path> tableViewCache = new AttributeCache(Preferences.instance().getInteger("browser.model.cache.size"));

    public TransferPromptModel(TransferPromptController c, Transfer transfer) {
        this.controller = c;
        this.transfer = transfer;
    }

    public void add(Path p) {
        this.roots.add((AbstractPath)p);
    }

    protected Path lookup(PathReference reference) {
        return this.transfer.lookup(reference);
    }

    @Override
    public void outlineView_setObjectValue_forTableColumn_byItem(NSOutlineView outlineView, NSObject value, NSTableColumn tableColumn, NSObject item) {
        String identifier = tableColumn.identifier();
        if (identifier.equals(INCLUDE_COLUMN)) {
            Path path = this.lookup(new OutlinePathReference(item));
            int state = Rococoa.cast(value, NSNumber.class).intValue();
            this.transfer.setSelected(path, state == 1);
            if (path.attributes().isDirectory()) {
                outlineView.setNeedsDisplay(true);
            }
        }
    }

    protected abstract PathFilter<Path> filter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributedList<Path> children(final Path path) {
        List<Path> list = this.isLoadingListingInBackground;
        synchronized (list) {
            if (!this.isLoadingListingInBackground.contains(path)) {
                if (this.transfer.cache().containsKey(path.getReference())) {
                    return this.transfer.cache().get(path.getReference(), (Comparator)new NullComparator(), this.filter());
                }
                this.isLoadingListingInBackground.add(path);
                this.controller.background((BackgroundAction)new AbstractBackgroundAction(){

                    public void run() {
                        TransferPromptModel.this.transfer.children(path);
                    }

                    public String getActivity() {
                        return MessageFormat.format(Locale.localizedString((String)"Listing directory {0}", (String)"Status"), path.getName());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cleanup() {
                        List list = TransferPromptModel.this.isLoadingListingInBackground;
                        synchronized (list) {
                            TransferPromptModel.this.isLoadingListingInBackground.remove(path);
                            if (TransferPromptModel.this.isLoadingListingInBackground.isEmpty()) {
                                TransferPromptModel.this.controller.reloadData();
                            }
                        }
                    }

                    public Object lock() {
                        return TransferPromptModel.this.transfer.getSession();
                    }
                });
            }
            return this.transfer.cache().get(path.getReference(), (Comparator)new NullComparator(), this.filter());
        }
    }

    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.tableViewCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals(INCLUDE_COLUMN)) {
                boolean included = this.transfer.isIncluded(item) && !this.controller.getAction().equals((Object)TransferAction.ACTION_SKIP);
                return NSNumber.numberWithInt(included ? 1 : 0);
            }
            if (identifier.equals(FILENAME_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.getName(), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSString.stringWithString(item.getName()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    @Override
    public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
        if (null == item) {
            return false;
        }
        return this.lookup(new OutlinePathReference(item)).attributes().isDirectory();
    }

    @Override
    public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
        if (null == item) {
            return new NSInteger(this.roots.size());
        }
        return new NSInteger(this.children(this.lookup(new OutlinePathReference(item))).size());
    }

    @Override
    public NSObject outlineView_child_ofItem(NSOutlineView view, NSInteger index, NSObject item) {
        if (null == item) {
            return (NSObject)((Path)this.roots.get(index.intValue())).getReference().unique();
        }
        AttributedList<Path> children = this.children(this.lookup(new OutlinePathReference(item)));
        if (children.isEmpty()) {
            return null;
        }
        return (NSObject)((Path)children.get(index.intValue())).getReference().unique();
    }

    @Override
    public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
        if (null == item) {
            return null;
        }
        return this.objectValueForItem(this.lookup(new OutlinePathReference(item)), tableColumn.identifier());
    }

    protected void clear() {
        this.tableViewCache.clear();
    }

    @Override
    protected void invalidate() {
        this.clear();
        super.invalidate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PromptFilter
    implements PathFilter<Path> {
        protected PromptFilter() {
        }

        public boolean accept(Path file) {
            return true;
        }
    }
}

