/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.NullTransferFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.TransferFilter;
import ch.cyberduck.ui.PathPasteboard;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.DownloadController;
import ch.cyberduck.ui.cocoa.ListDataSource;
import ch.cyberduck.ui.cocoa.ProgressController;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferTableDataSource
extends ListDataSource {
    private static Logger log = Logger.getLogger(TransferTableDataSource.class);
    public static final String PROGRESS_COLUMN = "PROGRESS";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    private final Map<Transfer, ProgressController> controllers = new HashMap<Transfer, ProgressController>();
    private TransferFilter filter = new NullTransferFilter();
    private AttributeCache<Transfer> cache = new AttributeCache(Preferences.instance().getInteger("queue.model.cache.size"));

    public TransferTableDataSource() {
        TransferCollection.defaultCollection().addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionItemRemoved(Transfer item) {
                ProgressController controller = (ProgressController)((Object)TransferTableDataSource.this.controllers.remove(item));
                if (controller != null) {
                    controller.invalidate();
                }
            }
        });
    }

    @Override
    protected void invalidate() {
        this.cache.clear();
        super.invalidate();
    }

    public void setFilter(final String searchString) {
        this.filter = StringUtils.isBlank((String)searchString) ? new NullTransferFilter() : new TransferFilter(){

            public boolean accept(Transfer transfer) {
                return transfer.getName().toLowerCase().contains(searchString.toLowerCase()) || transfer.getSession().getHost().getHostname().toLowerCase().contains(searchString.toLowerCase());
            }
        };
    }

    protected ch.cyberduck.core.Collection<Transfer> getSource() {
        if (null == this.filter) {
            return TransferCollection.defaultCollection();
        }
        if (this.filter instanceof NullTransferFilter) {
            return TransferCollection.defaultCollection();
        }
        ch.cyberduck.core.Collection filtered = new ch.cyberduck.core.Collection((Collection)TransferCollection.defaultCollection());
        Iterator i = filtered.iterator();
        while (i.hasNext()) {
            if (this.filter.accept((Transfer)i.next())) continue;
            i.remove();
        }
        return filtered;
    }

    @Override
    public NSInteger numberOfRowsInTableView(NSTableView view) {
        return new NSInteger(this.getSource().size());
    }

    @Override
    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        if (row.intValue() >= this.numberOfRowsInTableView(view).intValue()) {
            return null;
        }
        String identifier = tableColumn.identifier();
        Transfer item = (Transfer)this.getSource().get(row.intValue());
        NSObject cached = this.cache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals(PROGRESS_COLUMN)) {
                return this.cache.put(item, identifier, null);
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.cache.put(item, identifier, NSString.stringWithString(item.getName()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    @Override
    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        log.debug((Object)("tableViewValidateDrop:row:" + (Object)((Object)row) + ",operation:" + (Object)((Object)operation)));
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationCopy;
        }
        if (!PathPasteboard.allPasteboards().isEmpty()) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationCopy;
        }
        log.debug((Object)"tableViewValidateDrop:DragOperationNone");
        return NSDraggingInfo.NSDragOperationNone;
    }

    @Override
    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            String droppedText = draggingInfo.draggingPasteboard().stringForType("NSStringPboardType");
            if (StringUtils.isNotBlank((String)droppedText)) {
                log.info((Object)("NSPasteboard.StringPboardType:" + droppedText));
                DownloadController c = new DownloadController((WindowController)TransferController.instance(), droppedText);
                c.beginSheet();
                return true;
            }
            return false;
        }
        List pasteboards = PathPasteboard.allPasteboards();
        if (pasteboards.isEmpty()) {
            return false;
        }
        for (PathPasteboard pasteboard : pasteboards) {
            if (pasteboard.isEmpty()) continue;
            TransferCollection.defaultCollection().add(row.intValue(), (Transfer)new DownloadTransfer(pasteboard.copy()));
            view.reloadData();
            view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
            view.scrollRowToVisible(row);
        }
        pasteboards.clear();
        return true;
    }

    public ProgressController getController(int row) {
        return this.getController((Transfer)this.getSource().get(row));
    }

    public ProgressController getController(Transfer t) {
        if (!this.controllers.containsKey(t)) {
            this.controllers.put(t, new ProgressController(t));
        }
        return this.controllers.get(t);
    }

    public boolean isHighlighted(int row) {
        return this.getController(row).isHighlighted();
    }

    public void setHighlighted(int row, boolean highlighted) {
        this.getController(row).setHighlighted(highlighted);
    }
}

