/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.TransferPromptModel;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadPromptModel
extends TransferPromptModel {
    private PathFilter<Path> filter = new TransferPromptModel.PromptFilter(){

        public boolean accept(Path file) {
            TransferPromptModel.log.debug((Object)("accept:" + file));
            if (file.exists()) {
                if (file.attributes().getSize() == -1L) {
                    file.readSize();
                }
                if (file.getSession().isTimestampSupported() && file.attributes().getModificationDate() == -1L) {
                    file.readTimestamp();
                }
                return super.accept(file);
            }
            return false;
        }
    };

    public UploadPromptModel(TransferPromptController c, Transfer transfer) {
        super(c, transfer);
    }

    @Override
    protected PathFilter<Path> filter() {
        return this.filter;
    }

    @Override
    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.tableViewCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals("WARNING")) {
                if (item.attributes().isFile()) {
                    if (item.getLocal().attributes().getSize() == 0L) {
                        return this.tableViewCache.put(item, identifier, IconCache.iconNamed("alert.tiff"));
                    }
                    if (item.attributes().getSize() > item.getLocal().attributes().getSize()) {
                        return this.tableViewCache.put(item, identifier, IconCache.iconNamed("alert.tiff"));
                    }
                }
                return null;
            }
            if (identifier.equals("SIZE")) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)item.attributes().getSize()), TableCellAttributes.browserFontRightAlignment()));
            }
            return super.objectValueForItem(item, identifier);
        }
        return cached;
    }
}

