/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.PreferencesFactory;
import ch.cyberduck.ui.cocoa.UserDefaultsPortablePreferences;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSLocale;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSUserDefaults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefaultsPreferences
extends Preferences {
    private static Logger log = Logger.getLogger(Preferences.class);
    private NSUserDefaults props;

    public static void register() {
        PreferencesFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (PreferencesFactory)new Factory());
    }

    public String getDefault(String property) {
        String value = super.getDefault(property);
        if (null == value) {
            NSObject plist = NSBundle.mainBundle().infoDictionary().objectForKey(property);
            if (null == plist) {
                log.warn((Object)("No default value for property:" + property));
                return null;
            }
            return plist.toString();
        }
        return value;
    }

    public String getProperty(String property) {
        NSObject value = this.props.objectForKey(property);
        if (null == value) {
            return this.getDefault(property);
        }
        return value.toString();
    }

    public void setProperty(String property, String value) {
        if (log.isInfoEnabled()) {
            log.info((Object)("setProperty:" + property + "," + value));
        }
        if (StringUtils.isNotEmpty((String)value)) {
            this.props.setObjectForKey(NSString.stringWithString(value), property);
            this.save();
        }
    }

    public void setProperty(String property, List<String> value) {
        this.props.setObjectForKey(NSArray.arrayWithObjects(value.toArray(new String[value.size()])), property);
        this.save();
    }

    public void deleteProperty(String property) {
        log.debug((Object)("deleteProperty:" + property));
        this.props.removeObjectForKey(property);
        this.save();
    }

    protected void load() {
        this.props = NSUserDefaults.standardUserDefaults();
    }

    protected void post() {
        this._init("browser.view.autoexpand.useDelay");
        this._init("browser.view.autoexpand.delay");
        this._init("queue.maxtransfers");
        this._init("connection.retry");
        this._init("connection.retry.delay");
        this._init("connection.timeout.seconds");
        this._init("bookmark.icon.size");
        if (this.getBoolean("update.check")) {
            this.props.setInteger_forKey(new NSInteger(Long.parseLong(this.getProperty("update.check.interval"))), "SUScheduledCheckInterval");
        }
        super.post();
    }

    protected void setDefaults() {
        super.setDefaults();
        this.defaults.put("application.support.path", LocalFactory.createLocal((String)"~/Library/Application Support/Cyberduck").getAbbreviatedPath());
        this.defaults.put("application.name", NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleName").toString());
        this.defaults.put("application.version", NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleShortVersionString").toString());
        this.defaults.put("application.receipt.path", NSBundle.mainBundle().bundlePath() + "/Contents/_MASReceipt");
        this.defaults.put("update.feed.release", "http://version.cyberduck.ch/changelog.rss");
        this.defaults.put("update.feed.beta", "http://version.cyberduck.ch/beta/changelog.rss");
        this.defaults.put("update.feed.nightly", "http://version.cyberduck.ch/nightly/changelog.rss");
        this.defaults.put("bookmark.import.filezilla.location", "~/.filezilla/sitemanager.xml");
        this.defaults.put("bookmark.import.fetch.location", "~/Library/Preferences/com.fetchsoftworks.Fetch.Shortcuts.plist");
        this.defaults.put("bookmark.import.flow.location", "~/Library/Application Support/Flow/Bookmarks.plist");
        this.defaults.put("bookmark.import.interarchy.location", "~/Library/Application Support/Interarchy/Bookmarks.plist");
        this.defaults.put("bookmark.import.transmit.location", "~/Library/Preferences/com.panic.Transmit.plist");
        this.defaults.put("bookmark.import.crossftp.location", "~/.crossftp/sites.xml");
        this.defaults.put("bookmark.import.fireftp.location", "~/Library/Application Support/Firefox/Profiles");
        if (LocalFactory.createLocal((String)"~/Downloads").exists()) {
            this.defaults.put("queue.download.folder", "~/Downloads");
        } else {
            this.defaults.put("queue.download.folder", "~/Desktop");
        }
        this.defaults.put("ssh.knownhosts", "~/.ssh/known_hosts");
        this.defaults.put("browser.filesize.decimal", String.valueOf(!Factory.VERSION_PLATFORM.matches("10\\.5.*")));
    }

    private void _init(String property) {
        if (null == this.props.objectForKey(property)) {
            this.setProperty(property, this.getDefault(property));
        }
    }

    public void save() {
        this.props.synchronize();
    }

    public String locale() {
        NSObject value = this.props.objectForKey("AppleLanguages");
        if (null == value) {
            return super.locale();
        }
        List<String> languages = this.toList(Rococoa.cast(value, NSArray.class));
        if (null != languages) {
            return languages.iterator().next();
        }
        return super.locale();
    }

    public List<String> applicationLocales() {
        return this.toList(NSBundle.mainBundle().localizations());
    }

    public List<String> systemLocales() {
        return this.toList(NSLocale.preferredLanguages());
    }

    private List<String> toList(NSArray list) {
        NSObject next;
        if (null == list) {
            return Collections.emptyList();
        }
        ArrayList<String> localizations = new ArrayList<String>();
        NSEnumerator ordered = list.objectEnumerator();
        while ((next = ordered.nextObject()) != null) {
            localizations.add(next.toString());
        }
        return localizations;
    }

    private static class Factory
    extends PreferencesFactory {
        private Factory() {
        }

        protected Preferences create() {
            if (null == NSBundle.mainBundle().objectForInfoDictionaryKey("application.preferences.path")) {
                return new UserDefaultsPreferences();
            }
            return new UserDefaultsPortablePreferences();
        }
    }
}

