/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class AbstractMenuDelegate
extends ProxyController
implements NSMenu.Delegate {
    private static Logger log = Logger.getLogger(AbstractMenuDelegate.class);
    private boolean update;

    public AbstractMenuDelegate() {
        this.setNeedsUpdate(true);
    }

    public boolean menu_updateItem_atIndex_shouldCancel(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        return this.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("menuUpdateItemAtIndex:" + index.intValue()));
        }
        if (index.intValue() == this.numberOfItemsInMenu(menu).intValue() - 1) {
            this.setNeedsUpdate(false);
        }
        return !cancel;
    }

    protected abstract Selector getDefaultAction();

    protected ID getTarget() {
        return this.id();
    }

    protected String getKeyEquivalent() {
        return null;
    }

    protected int getModifierMask() {
        return 0x100000;
    }

    public boolean menuHasKeyEquivalent_forEvent(NSMenu menu, NSEvent event) {
        log.debug((Object)("menuHasKeyEquivalent_forEvent:" + menu));
        if (StringUtils.isBlank((String)this.getKeyEquivalent())) {
            return false;
        }
        if ((event.modifierFlags() & this.getModifierMask()) == this.getModifierMask()) {
            return event.charactersIgnoringModifiers().toLowerCase().equals(this.getKeyEquivalent());
        }
        return false;
    }

    public ID menuKeyEquivalentTarget_forEvent(NSMenu menu, NSEvent event) {
        log.debug((Object)("menuKeyEquivalentTarget_forEvent:" + menu));
        return this.getTarget();
    }

    public Selector menuKeyEquivalentAction_forEvent(NSMenu menu, NSEvent event) {
        log.debug((Object)("menuKeyEquivalentAction_forEvent:" + menu));
        return this.getDefaultAction();
    }

    protected void setNeedsUpdate(boolean u) {
        log.trace((Object)("setNeedsUpdate:" + u));
        this.update = u;
    }

    protected boolean isPopulated() {
        return !this.update;
    }

    protected NSMenuItem seperator() {
        return NSMenuItem.separatorItem();
    }

    public boolean validateMenuItem(NSMenuItem item) {
        return true;
    }

    protected void clearShortcut(NSMenuItem item) {
        this.setShortcut(item, "", 0);
    }

    protected void setShortcut(NSMenuItem item, String key) {
        this.setShortcut(item, key, 0);
    }

    protected void setShortcut(NSMenuItem item, String key, int modifier) {
        item.setKeyEquivalent(key);
        if (log.isDebugEnabled() && !item.keyEquivalent().equals(key)) {
            log.error((Object)("Failed to attach key equivalent to menu item:" + key));
        }
        item.setKeyEquivalentModifierMask(modifier);
    }
}

