/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CopyURLMenuDelegate
extends URLMenuDelegate {
    private static Logger log = Logger.getLogger(CopyURLMenuDelegate.class);

    @Override
    protected String getKeyEquivalent() {
        return "c";
    }

    @Override
    protected int getModifierMask() {
        return 0x120000;
    }

    @Override
    protected abstract List<Path> getSelected();

    @Override
    protected List<AbstractPath.DescriptiveUrl> getURLs(Path selected) {
        return new ArrayList<AbstractPath.DescriptiveUrl>(selected.getURLs());
    }

    @Override
    public void handle(List<String> selected) {
        StringBuilder url = new StringBuilder();
        Iterator<String> iter = selected.iterator();
        while (iter.hasNext()) {
            url.append(iter.next());
            if (!iter.hasNext()) continue;
            url.append("\n");
        }
        NSPasteboard pboard = NSPasteboard.generalPasteboard();
        pboard.declareTypes(NSArray.arrayWithObject(NSString.stringWithString("NSStringPboardType")), null);
        if (!pboard.setStringForType(url.toString(), "NSStringPboardType")) {
            log.error((Object)"Error writing URL to NSPasteboard.StringPboardType.");
        }
    }
}

