/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class EditMenuDelegate
extends AbstractMenuDelegate {
    private static Logger log = Logger.getLogger(EditMenuDelegate.class);
    private String extension = null;

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        int n = EditorFactory.getInstalledEditors(this.getSelectedFile()).size();
        if (0 == n) {
            return new NSInteger(1L);
        }
        return new NSInteger(n);
    }

    protected abstract Local getSelectedFile();

    protected boolean isPopulated() {
        Local selected = this.getSelectedFile();
        if (selected != null && ObjectUtils.equals((Object)this.extension, (Object)selected.getExtension())) {
            return true;
        }
        this.extension = selected != null ? selected.getExtension() : null;
        return false;
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        Local selected = this.getSelectedFile();
        Map<String, String> editors = EditorFactory.getInstalledEditors(selected);
        if (editors.size() == 0) {
            item.setTitle(Locale.localizedString((String)"No external editor available"));
            return false;
        }
        String defaultEditor = EditorFactory.defaultEditor(selected);
        String identifier = editors.values().toArray(new String[editors.size()])[index.intValue()];
        item.setRepresentedObject(identifier);
        String editor = editors.keySet().toArray(new String[editors.size()])[index.intValue()];
        item.setTitle(editor);
        if (identifier.equalsIgnoreCase(defaultEditor)) {
            this.setShortcut(item, this.getKeyEquivalent(), this.getModifierMask());
        } else {
            this.clearShortcut(item);
        }
        item.setImage(IconCache.instance().iconForApplication(identifier, 16));
        item.setAction(Foundation.selector("editMenuClicked:"));
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    protected String getKeyEquivalent() {
        return "k";
    }

    protected int getModifierMask() {
        return 0x100000;
    }

    protected Selector getDefaultAction() {
        return Foundation.selector("editButtonClicked:");
    }
}

