/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import java.util.Date;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HistoryMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static Logger log = Logger.getLogger(HistoryMenuDelegate.class);
    protected static final NSDictionary TIMESTAMP_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.userFontOfSize(NSFont.smallSystemFontSize()), NSColor.darkGrayColor(), TableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE), NSArray.arrayWithObjects("NSFont", "NSColor", "NSParagraphStyle"));

    public HistoryMenuDelegate() {
        super(HistoryCollection.defaultCollection());
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        if (this.collection().size() > 0) {
            return new NSInteger(this.collection().size() * 2 + 2);
        }
        return new NSInteger(1L);
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        if (cancel) {
            return false;
        }
        int size = this.collection().size();
        if (size == 0) {
            item.setTitle(Locale.localizedString((String)"No recently connected servers available"));
            item.setTarget(null);
            item.setAction(null);
            item.setImage(null);
            item.setEnabled(false);
            return false;
        }
        if (index.intValue() < size * 2) {
            boolean label = index.intValue() % 2 == 0;
            Host h = (Host)this.collection().get(index.intValue() / 2);
            if (label) {
                item.setTitle(h.getNickname());
                item.setAction(this.getDefaultAction());
                item.setRepresentedObject(h.getUuid());
                item.setTarget(this.id());
                item.setEnabled(true);
                item.setImage(IconCache.iconNamed(h.getProtocol().icon(), 16));
            } else {
                Date timestamp = h.getTimestamp();
                if (null != timestamp) {
                    item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes(DateFormatterFactory.instance().getLongFormat(timestamp.getTime()), TIMESTAMP_FONT_ATTRIBUTES));
                } else {
                    item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Unknown"), TIMESTAMP_FONT_ATTRIBUTES));
                }
            }
        } else if (index.intValue() == size * 2) {
            item.setTitle("");
            item.setTarget(null);
            item.setAction(null);
            item.setImage(null);
            item.setEnabled(false);
        } else if (index.intValue() == size * 2 + 1) {
            item.setTitle(Locale.localizedString((String)"Clear Menu"));
            item.setAction(Foundation.selector("clearMenuItemClicked:"));
            item.setTarget(this.id());
            item.setEnabled(true);
        }
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void historyMenuItemClicked(NSMenuItem sender) {
        log.debug((Object)("historyMenuItemClicked:" + sender));
        BrowserController controller = MainController.newDocument();
        controller.mount(((AbstractHostCollection)this.collection()).lookup(sender.representedObject()));
    }

    public void clearMenuItemClicked(NSMenuItem sender) {
        this.collection().clear();
    }

    @Override
    protected Selector getDefaultAction() {
        return Foundation.selector("historyMenuItemClicked:");
    }
}

