/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLMenuDelegate
extends AbstractMenuDelegate {
    private static Logger log = Logger.getLogger(URLMenuDelegate.class);
    protected static final NSDictionary URL_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.userFontOfSize(NSFont.smallSystemFontSize()), NSColor.darkGrayColor(), TableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE), NSArray.arrayWithObjects("NSFont", "NSColor", "NSParagraphStyle"));

    protected abstract List<Path> getSelected();

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        List<Path> selected = this.getSelected();
        if (selected.isEmpty()) {
            return new NSInteger(1L);
        }
        int urls = this.getURLs(selected.iterator().next()).size();
        if (0 == urls) {
            return new NSInteger(1L);
        }
        return new NSInteger(urls * 2);
    }

    protected abstract List<AbstractPath.DescriptiveUrl> getURLs(Path var1);

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        List<Path> selected = this.getSelected();
        if (0 == index.intValue()) {
            this.setShortcut(item, this.getKeyEquivalent(), this.getModifierMask());
        } else {
            this.clearShortcut(item);
        }
        if (selected.isEmpty() || this.getURLs(selected.iterator().next()).isEmpty()) {
            item.setTitle(Locale.localizedString((String)"None"));
            item.setEnabled(false);
            item.setAction(null);
            item.setTarget(null);
            item.setImage(null);
        } else {
            boolean label;
            StringBuilder builder = new StringBuilder();
            Iterator<Path> iter = selected.iterator();
            while (iter.hasNext()) {
                List<AbstractPath.DescriptiveUrl> urls = this.getURLs(iter.next());
                AbstractPath.DescriptiveUrl url = urls.get(index.intValue() / 2);
                builder.append(url.getUrl());
                if (!iter.hasNext()) continue;
                builder.append("\n");
            }
            String s = builder.toString();
            boolean bl = label = index.intValue() % 2 == 0;
            if (label) {
                item.setEnabled(true);
                item.setTarget(this.id());
                item.setAction(Foundation.selector("menuItemClicked:"));
                item.setImage(IconCache.iconNamed("site.tiff", 16));
                Iterator<Path> iter2 = selected.iterator();
                AbstractPath.DescriptiveUrl url = this.getURLs(iter2.next()).get(index.intValue() / 2);
                item.setRepresentedObject(s);
                item.setTitle(url.getHelp());
            } else if (StringUtils.isNotBlank((String)s)) {
                item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes(s, URL_FONT_ATTRIBUTES));
            } else {
                item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Unknown"), URL_FONT_ATTRIBUTES));
            }
        }
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void menuActionSelected(NSMenu sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("menuActionSelected:" + sender));
        }
        ArrayList<String> selected = new ArrayList<String>();
        for (Path path : this.getSelected()) {
            selected.add(this.getURLs(path).iterator().next().getUrl());
        }
        this.handle(selected);
    }

    public void menuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("menuItemClicked:" + sender));
        }
        this.handle(Arrays.asList(StringUtils.split((String)sender.representedObject(), (String)"\n")));
    }

    public abstract void handle(List<String> var1);

    @Override
    public boolean validateMenuItem(NSMenuItem item) {
        if (this.getSelected().isEmpty()) {
            return false;
        }
        Selector action = item.action();
        if (action.equals((Object)this.getDefaultAction())) {
            return StringUtils.isNotBlank((String)item.representedObject());
        }
        return true;
    }

    @Override
    protected ID getTarget() {
        return this.id();
    }

    @Override
    protected Selector getDefaultAction() {
        return Foundation.selector("menuActionSelected:");
    }
}

