/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.io;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.cyberduck.ui.cocoa.io.FileWatcherListener;
import com.barbarysoftware.watchservice.ClosedWatchServiceException;
import com.barbarysoftware.watchservice.StandardWatchEventKind;
import com.barbarysoftware.watchservice.WatchEvent;
import com.barbarysoftware.watchservice.WatchKey;
import com.barbarysoftware.watchservice.WatchService;
import com.barbarysoftware.watchservice.WatchableFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class FileWatcher {
    private static Logger log = Logger.getLogger(FileWatcher.class);
    private WatchService monitor;
    private Local file;
    private Set<FileWatcherListener> listeners = Collections.synchronizedSet(new HashSet());

    public FileWatcher(Local file) {
        this.file = file;
    }

    public void register() {
        log.debug((Object)("register:" + this.file));
        this.monitor = WatchService.newWatchService();
        WatchableFile watchable = new WatchableFile(new File(this.file.getParent().getAbsolute()));
        try {
            watchable.register(this.monitor, StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        AtomicReference<Thread> consumer = new AtomicReference<Thread>(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    NSAutoreleasePool pool = NSAutoreleasePool.push();
                    try {
                        WatchKey key;
                        try {
                            key = FileWatcher.this.monitor.take();
                        }
                        catch (ClosedWatchServiceException e) {
                            pool.release();
                            return;
                        }
                        catch (InterruptedException e) {
                            pool.release();
                            return;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            log.info((Object)("Detected file system event: " + kind));
                            if (kind == StandardWatchEventKind.OVERFLOW) continue;
                            WatchEvent<?> ev = event;
                            Local f = LocalFactory.createLocal((File)((File)ev.context()));
                            if (f.equals((Object)FileWatcher.this.file)) {
                                if (StandardWatchEventKind.ENTRY_MODIFY == kind) {
                                    for (FileWatcherListener l : FileWatcher.this.listeners.toArray(new FileWatcherListener[FileWatcher.this.listeners.size()])) {
                                        l.fileWritten(f);
                                    }
                                }
                                if (StandardWatchEventKind.ENTRY_DELETE != kind) continue;
                                for (FileWatcherListener l : FileWatcher.this.listeners.toArray(new FileWatcherListener[FileWatcher.this.listeners.size()])) {
                                    l.fileDeleted(f);
                                }
                                continue;
                            }
                            log.debug((Object)("Ignored file system event for " + f));
                        }
                        boolean valid = key.reset();
                        if (valid) continue;
                    }
                    finally {
                        pool.release();
                        continue;
                    }
                    break;
                }
            }
        }));
        consumer.get().start();
    }

    public void addListener(FileWatcherListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FileWatcherListener listener) {
        if (this.listeners.isEmpty()) {
            log.debug((Object)("unwatch:" + this.file));
            try {
                this.monitor.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
    }
}

