/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.odb;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.editor.AbstractEditor;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;

public abstract class Editor
extends AbstractEditor {
    private static Logger log = Logger.getLogger(Editor.class);
    private BrowserController controller;
    protected String bundleIdentifier;

    public Editor(BrowserController controller, String bundleIdentifier, Path path) {
        super(path);
        this.controller = controller;
        this.bundleIdentifier = bundleIdentifier;
    }

    public void open(final BackgroundAction download) {
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                download.run();
            }

            public String getActivity() {
                return download.getActivity();
            }

            public void cleanup() {
                download.cleanup();
            }
        });
    }

    public boolean isOpen() {
        NSObject next;
        NSEnumerator apps = NSWorkspace.sharedWorkspace().launchedApplications().objectEnumerator();
        while ((next = apps.nextObject()) != null) {
            NSDictionary app = Rococoa.cast(next, NSDictionary.class);
            NSObject identifier = app.objectForKey("NSApplicationBundleIdentifier");
            if (!identifier.toString().equals(this.bundleIdentifier)) continue;
            return true;
        }
        return false;
    }

    protected void save(final BackgroundAction upload) {
        log.debug((Object)"save");
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                upload.run();
            }

            public String getActivity() {
                return upload.getActivity();
            }

            public void cleanup() {
                upload.cleanup();
            }
        });
    }
}

