/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.odb;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.io.FileWatcher;
import ch.cyberduck.ui.cocoa.io.FileWatcherListener;
import ch.cyberduck.ui.cocoa.odb.Editor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchEditor
extends Editor
implements FileWatcherListener {
    private static Logger log = Logger.getLogger(WatchEditor.class);
    private static final Map<String, String> SUPPORTED_KQUEUE_EDITORS = new HashMap<String, String>();
    private static final Map<String, String> INSTALLED_KQUEUE_EDITORS = new HashMap<String, String>();
    private FileWatcher monitor;

    public static void addInstalledEditor(String name, String identifier) {
        SUPPORTED_KQUEUE_EDITORS.put(name, identifier);
        INSTALLED_KQUEUE_EDITORS.put(name, identifier);
    }

    public static Map<String, String> getSupportedEditors() {
        return SUPPORTED_KQUEUE_EDITORS;
    }

    public static Map<String, String> getInstalledEditors() {
        return INSTALLED_KQUEUE_EDITORS;
    }

    public WatchEditor(BrowserController c, Path path) {
        this(c, path.getLocal().getDefaultApplication(), path);
    }

    public WatchEditor(BrowserController c, String bundleIdentifier, Path path) {
        super(c, bundleIdentifier, path);
    }

    protected TransferAction getAction() {
        return TransferAction.ACTION_RENAME;
    }

    public void edit() {
        NSWorkspace.sharedWorkspace().openFile(this.edited.getLocal().getAbsolute(), NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(this.bundleIdentifier));
        this.watch();
    }

    public void watch() {
        this.monitor = new FileWatcher(this.edited.getLocal());
        this.monitor.register();
        this.monitor.addListener(this);
    }

    protected void delete() {
        this.monitor.removeListener(this);
        super.delete();
    }

    protected void setDeferredDelete(boolean deferredDelete) {
        if (!this.isOpen()) {
            this.delete();
        }
        super.setDeferredDelete(deferredDelete);
    }

    @Override
    public void fileWritten(Local file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("fileWritten:" + file));
        }
        this.save();
    }

    @Override
    public void fileRenamed(Local file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("fileRenamed:" + file));
        }
    }

    @Override
    public void fileDeleted(Local file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("fileDeleted:" + file));
        }
        this.monitor.removeListener(this);
    }

    static {
        SUPPORTED_KQUEUE_EDITORS.put("TextEdit", "com.apple.TextEdit");
        SUPPORTED_KQUEUE_EDITORS.put("Xcode", "com.apple.Xcode");
        Iterator<String> editorNames = SUPPORTED_KQUEUE_EDITORS.keySet().iterator();
        Iterator<String> editorIdentifiers = SUPPORTED_KQUEUE_EDITORS.values().iterator();
        while (editorNames.hasNext()) {
            String editor = editorNames.next();
            String identifier = editorIdentifiers.next();
            String path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(identifier);
            if (StringUtils.isEmpty((String)path)) continue;
            WatchEditor.addInstalledEditor(editor, identifier);
        }
    }
}

