/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.serializer;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.serializer.Reader;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlistReader<S extends Serializable>
implements Reader<S> {
    private static Logger log = Logger.getLogger(PlistReader.class);

    public Collection<S> readCollection(Local file) {
        NSObject next;
        Collection c = new Collection();
        NSArray list = NSArray.arrayWithContentsOfFile(file.getAbsolute());
        if (null == list) {
            log.error((Object)("Invalid bookmark file:" + file));
            return c;
        }
        NSEnumerator i = list.objectEnumerator();
        while ((next = i.nextObject()) != null) {
            NSDictionary dict = Rococoa.cast(next, NSDictionary.class);
            c.add(this.deserialize(dict));
        }
        return c;
    }

    public S read(Local file) {
        NSDictionary dict = NSDictionary.dictionaryWithContentsOfFile(file.getAbsolute());
        if (null == dict) {
            log.error((Object)("Invalid bookmark file:" + file));
            return null;
        }
        return this.deserialize(dict);
    }

    public abstract S deserialize(NSDictionary var1);
}

