/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.serializer;

import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.serializer.Reader;
import ch.cyberduck.core.serializer.TransferReaderFactory;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.serializer.PlistReader;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferPlistReader
extends PlistReader<Transfer> {
    private static Logger log = Logger.getLogger(TransferPlistReader.class);

    public static void register() {
        TransferReaderFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (TransferReaderFactory)new Factory());
    }

    public Transfer deserialize(NSDictionary dict, Session s) {
        NSObject kindObj = dict.objectForKey("Kind");
        if (kindObj != null) {
            int kind = Integer.parseInt(kindObj.toString());
            switch (kind) {
                case 0: {
                    return new DownloadTransfer((Object)dict, s);
                }
                case 1: {
                    return new UploadTransfer((Object)dict, s);
                }
                case 2: {
                    return new SyncTransfer((Object)dict, s);
                }
            }
        }
        log.error((Object)("Unknown transfer:" + kindObj));
        return null;
    }

    @Override
    public Transfer deserialize(NSDictionary dict) {
        NSObject hostObj = dict.objectForKey("Host");
        if (hostObj != null) {
            Host host = new Host((Object)Rococoa.cast(hostObj, NSDictionary.class));
            Session s = SessionFactory.createSession((Host)host);
            return this.deserialize(dict, s);
        }
        throw new IllegalArgumentException("Unknown transfer");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends TransferReaderFactory {
        private Factory() {
        }

        public Reader<Transfer> create() {
            return new TransferPlistReader();
        }
    }
}

