/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.threading;

import ch.cyberduck.core.Session;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.threading.AlertRepeatableBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;

public abstract class BrowserBackgroundAction
extends AlertRepeatableBackgroundAction {
    private BrowserController controller;

    public BrowserBackgroundAction(BrowserController controller) {
        super(controller);
        this.controller = controller;
    }

    public BrowserController getController() {
        return this.controller;
    }

    public Session getSession() {
        return this.controller.getSession();
    }

    public boolean prepare() {
        this.controller.invoke((MainAction)new WindowMainAction(this.controller){

            public void run() {
                BrowserBackgroundAction.this.controller.getStatusSpinner().startAnimation(null);
                BrowserBackgroundAction.this.controller.updateStatusLabel(BrowserBackgroundAction.this.getActivity());
            }
        });
        return super.prepare();
    }

    public void cancel() {
        if (this.isRunning()) {
            this.getSession().interrupt();
        }
        super.cancel();
    }

    public void finish() {
        super.finish();
        this.controller.invoke((MainAction)new WindowMainAction(this.controller){

            public void run() {
                BrowserBackgroundAction.this.controller.getStatusSpinner().stopAnimation(null);
                BrowserBackgroundAction.this.controller.updateStatusLabel();
            }
        });
    }

    public boolean isCanceled() {
        if (null == this.getSession()) {
            return true;
        }
        return super.isCanceled();
    }
}

