/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.urlhandler;

import ch.cyberduck.core.Native;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import org.apache.log4j.Logger;

public class URLSchemeHandlerConfiguration {
    private static Logger log = Logger.getLogger(URLSchemeHandlerConfiguration.class);
    private static URLSchemeHandlerConfiguration instance;

    public static URLSchemeHandlerConfiguration instance() {
        if (null == instance) {
            instance = new URLSchemeHandlerConfiguration();
        }
        return instance;
    }

    public native void setDefaultHandlerForURLScheme(String var1, String var2);

    public void setDefaultHandlerForURLScheme(String[] scheme, String bundleIdentifier) {
        for (String aScheme : scheme) {
            this.setDefaultHandlerForURLScheme(aScheme, bundleIdentifier);
        }
    }

    public native String getDefaultHandlerForURLScheme(String var1);

    public native String[] getAllHandlersForURLScheme(String var1);

    public boolean isDefaultHandlerForURLScheme(String scheme) {
        return NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleIdentifier").toString().equals(this.getDefaultHandlerForURLScheme(scheme));
    }

    public boolean isDefaultHandlerForURLScheme(String[] scheme) {
        boolean isDefault = true;
        for (String aScheme : scheme) {
            if (this.isDefaultHandlerForURLScheme(aScheme)) continue;
            isDefault = false;
            break;
        }
        return isDefault;
    }

    static {
        Native.load((String)"URLSchemeHandlerConfiguration");
    }
}

