/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.jna.CFArrayRef;
import com.barbarysoftware.jna.CFIndex;
import com.barbarysoftware.jna.CFRunLoopRef;
import com.barbarysoftware.jna.CFStringRef;
import com.barbarysoftware.jna.CarbonAPI;
import com.barbarysoftware.jna.FSEventStreamRef;
import com.barbarysoftware.watchservice.AbstractWatchKey;
import com.barbarysoftware.watchservice.AbstractWatchService;
import com.barbarysoftware.watchservice.StandardWatchEventKind;
import com.barbarysoftware.watchservice.WatchEvent;
import com.barbarysoftware.watchservice.WatchKey;
import com.barbarysoftware.watchservice.WatchableFile;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MacOSXWatchService
extends AbstractWatchService {
    private final List<CarbonAPI.FSEventStreamCallback> callbackList = new ArrayList<CarbonAPI.FSEventStreamCallback>();
    private final List<CFRunLoopThread> threadList = new ArrayList<CFRunLoopThread>();

    MacOSXWatchService() {
    }

    @Override
    WatchKey register(WatchableFile watchableFile, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifers) throws IOException {
        File file = watchableFile.getFile();
        Map<File, Long> lastModifiedMap = this.createLastModifiedMap(file);
        String s = file.getAbsolutePath();
        Pointer[] values = new Pointer[]{CFStringRef.toCFString(s).getPointer()};
        CFArrayRef pathsToWatch = CarbonAPI.INSTANCE.CFArrayCreate(null, values, CFIndex.valueOf(1), null);
        MacOSXWatchKey watchKey = new MacOSXWatchKey(this, events);
        double latency = 1.0;
        long kFSEventStreamEventIdSinceNow = -1L;
        int kFSEventStreamCreateFlagNoDefer = 2;
        Callback callback = new Callback(watchKey, lastModifiedMap);
        this.callbackList.add(callback);
        FSEventStreamRef stream = CarbonAPI.INSTANCE.FSEventStreamCreate(Pointer.NULL, callback, Pointer.NULL, pathsToWatch, -1L, 1.0, 2);
        CFRunLoopThread thread = new CFRunLoopThread(stream);
        thread.setDaemon(true);
        thread.start();
        this.threadList.add(thread);
        return watchKey;
    }

    private Map<File, Long> createLastModifiedMap(File folder) {
        ConcurrentHashMap<File, Long> lastModifiedMap = new ConcurrentHashMap<File, Long>();
        for (File file : MacOSXWatchService.recursiveListFiles(folder)) {
            lastModifiedMap.put(file, file.lastModified());
        }
        return lastModifiedMap;
    }

    private static Set<File> recursiveListFiles(File folder) {
        HashSet<File> files = new HashSet<File>();
        if (folder.isDirectory()) {
            File[] children = folder.listFiles();
            if (null == children) {
                return files;
            }
            for (File file : children) {
                if (file.isDirectory()) {
                    files.addAll(MacOSXWatchService.recursiveListFiles(file));
                    continue;
                }
                files.add(file);
            }
        }
        return files;
    }

    @Override
    void implClose() throws IOException {
        for (CFRunLoopThread thread : this.threadList) {
            CarbonAPI.INSTANCE.CFRunLoopStop(thread.getRunLoop());
            CarbonAPI.INSTANCE.FSEventStreamStop(thread.getStreamRef());
        }
        this.threadList.clear();
        this.callbackList.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Callback
    implements CarbonAPI.FSEventStreamCallback {
        private final MacOSXWatchKey watchKey;
        private final Map<File, Long> lastModifiedMap;

        private Callback(MacOSXWatchKey watchKey, Map<File, Long> lastModifiedMap) {
            this.watchKey = watchKey;
            this.lastModifiedMap = lastModifiedMap;
        }

        @Override
        public void invoke(FSEventStreamRef streamRef, Pointer clientCallBackInfo, NativeLong numEvents, Pointer eventPaths, Pointer eventFlags, Pointer eventIds) {
            int length = numEvents.intValue();
            for (String folderName : eventPaths.getStringArray(0L, length)) {
                Set filesOnDisk = MacOSXWatchService.recursiveListFiles(new File(folderName));
                for (File file : this.findCreatedFiles(filesOnDisk)) {
                    if (this.watchKey.isReportCreateEvents()) {
                        this.watchKey.signalEvent(StandardWatchEventKind.ENTRY_CREATE, file);
                    }
                    this.lastModifiedMap.put(file, file.lastModified());
                }
                for (File file : this.findModifiedFiles(filesOnDisk)) {
                    if (this.watchKey.isReportModifyEvents()) {
                        this.watchKey.signalEvent(StandardWatchEventKind.ENTRY_MODIFY, file);
                    }
                    this.lastModifiedMap.put(file, file.lastModified());
                }
                for (File file : this.findDeletedFiles(folderName, filesOnDisk)) {
                    if (this.watchKey.isReportDeleteEvents()) {
                        this.watchKey.signalEvent(StandardWatchEventKind.ENTRY_DELETE, file);
                    }
                    this.lastModifiedMap.remove(file);
                }
            }
        }

        private List<File> findModifiedFiles(Set<File> filesOnDisk) {
            ArrayList<File> modifiedFileList = new ArrayList<File>();
            for (File file : filesOnDisk) {
                Long lastModified = this.lastModifiedMap.get(file);
                if (lastModified == null || lastModified.longValue() == file.lastModified()) continue;
                modifiedFileList.add(file);
            }
            return modifiedFileList;
        }

        private List<File> findCreatedFiles(Set<File> filesOnDisk) {
            ArrayList<File> createdFileList = new ArrayList<File>();
            for (File file : filesOnDisk) {
                if (this.lastModifiedMap.containsKey(file)) continue;
                createdFileList.add(file);
            }
            return createdFileList;
        }

        private List<File> findDeletedFiles(String folderName, Set<File> filesOnDisk) {
            ArrayList<File> deletedFileList = new ArrayList<File>();
            for (File file : this.lastModifiedMap.keySet()) {
                if (!file.getAbsolutePath().startsWith(folderName) || filesOnDisk.contains(file)) continue;
                deletedFileList.add(file);
            }
            return deletedFileList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MacOSXWatchKey
    extends AbstractWatchKey {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final boolean reportCreateEvents;
        private final boolean reportModifyEvents;
        private final boolean reportDeleteEvents;

        public MacOSXWatchKey(MacOSXWatchService macOSXWatchService, WatchEvent.Kind<?>[] events) {
            super(macOSXWatchService);
            boolean reportCreateEvents = false;
            boolean reportModifyEvents = false;
            boolean reportDeleteEvents = false;
            for (WatchEvent.Kind<?> event : events) {
                if (event == StandardWatchEventKind.ENTRY_CREATE) {
                    reportCreateEvents = true;
                    continue;
                }
                if (event == StandardWatchEventKind.ENTRY_MODIFY) {
                    reportModifyEvents = true;
                    continue;
                }
                if (event != StandardWatchEventKind.ENTRY_DELETE) continue;
                reportDeleteEvents = true;
            }
            this.reportCreateEvents = reportCreateEvents;
            this.reportDeleteEvents = reportDeleteEvents;
            this.reportModifyEvents = reportModifyEvents;
        }

        @Override
        public boolean isValid() {
            return !this.cancelled.get() && this.watcher().isOpen();
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
        }

        public boolean isReportCreateEvents() {
            return this.reportCreateEvents;
        }

        public boolean isReportModifyEvents() {
            return this.reportModifyEvents;
        }

        public boolean isReportDeleteEvents() {
            return this.reportDeleteEvents;
        }
    }

    public static class CFRunLoopThread
    extends Thread {
        private final FSEventStreamRef streamRef;
        private CFRunLoopRef runLoop;

        public CFRunLoopThread(FSEventStreamRef streamRef) {
            this.streamRef = streamRef;
        }

        public void run() {
            this.runLoop = CarbonAPI.INSTANCE.CFRunLoopGetCurrent();
            CFStringRef runLoopMode = CFStringRef.toCFString("kCFRunLoopDefaultMode");
            CarbonAPI.INSTANCE.FSEventStreamScheduleWithRunLoop(this.streamRef, this.runLoop, runLoopMode);
            CarbonAPI.INSTANCE.FSEventStreamStart(this.streamRef);
            CarbonAPI.INSTANCE.CFRunLoopRun();
        }

        public CFRunLoopRef getRunLoop() {
            return this.runLoop;
        }

        public FSEventStreamRef getStreamRef() {
            return this.streamRef;
        }
    }
}

